#ifndef CUFFTDX_FFT_128_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_128_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<253, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<535>;
.reg .b32 r<14>;
.reg .b64 rd<6>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 9;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f65, %34, %55;
add.f32 f66, %35, %57;
sub.f32 f67, %34, %55;
sub.f32 f68, %35, %57;
add.f32 f69, %44, %66;
add.f32 f70, %46, %67;
sub.f32 f71, %44, %66;
sub.f32 f72, %46, %67;
add.f32 f73, f65, f69;
add.f32 f74, f66, f70;
sub.f32 f75, f65, f69;
sub.f32 f76, f66, f70;
sub.f32 f77, f67, f72;
add.f32 f78, f68, f71;
add.f32 f79, f67, f72;
sub.f32 f80, f68, f71;
add.f32 f81, %39, %60;
add.f32 f82, %41, %62;
sub.f32 f83, %39, %60;
sub.f32 f84, %41, %62;
add.f32 f85, %50, %71;
add.f32 f86, %51, %73;
sub.f32 f87, %50, %71;
sub.f32 f88, %51, %73;
add.f32 f89, f81, f85;
add.f32 f90, f82, f86;
sub.f32 f91, f81, f85;
sub.f32 f92, f82, f86;
sub.f32 f93, f83, f88;
add.f32 f94, f84, f87;
add.f32 f95, f83, f88;
sub.f32 f96, f84, f87;
mul.f32 f97, f93, 0f3F3504F3;
mul.f32 f98, f94, 0f3F3504F3;
sub.f32 f99, f97, f98;
add.f32 f100, f97, f98;
mul.f32 f101, f95, 0fBF3504F3;
mul.f32 f102, f96, 0f3F3504F3;
sub.f32 f103, f101, f102;
mul.f32 f104, f96, 0fBF3504F3;
fma.rn.f32 f105, f95, 0f3F3504F3, f104;
add.f32 f106, f73, f89;
add.f32 f107, f74, f90;
sub.f32 f108, f73, f89;
sub.f32 f109, f74, f90;
add.f32 f110, f77, f99;
add.f32 f111, f78, f100;
sub.f32 f112, f77, f99;
sub.f32 f113, f78, f100;
sub.f32 f114, f75, f92;
add.f32 f115, f76, f91;
add.f32 f116, f75, f92;
sub.f32 f117, f76, f91;
add.f32 f118, f79, f103;
add.f32 f119, f80, f105;
sub.f32 f120, f79, f103;
sub.f32 f121, f80, f105;
add.f32 f122, %36, %58;
add.f32 f123, %38, %59;
sub.f32 f124, %36, %58;
sub.f32 f125, %38, %59;
add.f32 f126, %47, %68;
add.f32 f127, %49, %70;
sub.f32 f128, %47, %68;
sub.f32 f129, %49, %70;
add.f32 f130, f122, f126;
add.f32 f131, f123, f127;
sub.f32 f132, f122, f126;
sub.f32 f133, f123, f127;
sub.f32 f134, f124, f129;
add.f32 f135, f125, f128;
add.f32 f136, f124, f129;
sub.f32 f137, f125, f128;
add.f32 f138, %42, %63;
add.f32 f139, %43, %65;
sub.f32 f140, %42, %63;
sub.f32 f141, %43, %65;
add.f32 f142, %52, %74;
add.f32 f143, %54, %75;
sub.f32 f144, %52, %74;
sub.f32 f145, %54, %75;
add.f32 f146, f138, f142;
add.f32 f147, f139, f143;
sub.f32 f148, f138, f142;
sub.f32 f149, f139, f143;
sub.f32 f150, f140, f145;
add.f32 f151, f141, f144;
add.f32 f152, f140, f145;
sub.f32 f153, f141, f144;
mul.f32 f154, f150, 0f3F3504F3;
mul.f32 f155, f151, 0f3F3504F3;
sub.f32 f156, f154, f155;
add.f32 f157, f154, f155;
mul.f32 f158, f152, 0fBF3504F3;
mul.f32 f159, f153, 0f3F3504F3;
sub.f32 f160, f158, f159;
mul.f32 f161, f153, 0fBF3504F3;
fma.rn.f32 f162, f152, 0f3F3504F3, f161;
add.f32 f163, f130, f146;
add.f32 f164, f131, f147;
sub.f32 f165, f130, f146;
sub.f32 f166, f131, f147;
add.f32 f167, f134, f156;
add.f32 f168, f135, f157;
sub.f32 f169, f134, f156;
sub.f32 f170, f135, f157;
sub.f32 f171, f132, f149;
add.f32 f172, f133, f148;
add.f32 f173, f132, f149;
sub.f32 f174, f133, f148;
add.f32 f175, f136, f160;
add.f32 f176, f137, f162;
sub.f32 f177, f136, f160;
sub.f32 f178, f137, f162;
mul.f32 f179, f167, 0f3F6C835E;
mul.f32 f180, f168, 0f3EC3EF15;
sub.f32 f181, f179, f180;
mul.f32 f182, f168, 0f3F6C835E;
fma.rn.f32 f183, f167, 0f3EC3EF15, f182;
mul.f32 f184, f171, 0f3F3504F3;
mul.f32 f185, f172, 0f3F3504F3;
sub.f32 f186, f184, f185;
add.f32 f187, f184, f185;
mul.f32 f188, f175, 0f3EC3EF15;
mul.f32 f189, f176, 0f3F6C835E;
sub.f32 f190, f188, f189;
mul.f32 f191, f176, 0f3EC3EF15;
fma.rn.f32 f192, f175, 0f3F6C835E, f191;
mul.f32 f193, f169, 0fBEC3EF15;
mul.f32 f194, f170, 0f3F6C835E;
sub.f32 f195, f193, f194;
mul.f32 f196, f170, 0fBEC3EF15;
fma.rn.f32 f197, f169, 0f3F6C835E, f196;
mul.f32 f198, f173, 0fBF3504F3;
mul.f32 f199, f174, 0f3F3504F3;
sub.f32 f200, f198, f199;
mul.f32 f201, f174, 0fBF3504F3;
fma.rn.f32 f202, f173, 0f3F3504F3, f201;
mul.f32 f203, f177, 0fBF6C835E;
mul.f32 f204, f178, 0f3EC3EF15;
sub.f32 f205, f203, f204;
mul.f32 f206, f178, 0fBF6C835E;
fma.rn.f32 f207, f177, 0f3EC3EF15, f206;
add.f32 f208, f106, f163;
add.f32 f209, f107, f164;
sub.f32 f210, f106, f163;
sub.f32 f211, f107, f164;
add.f32 f212, f110, f181;
add.f32 f213, f111, f183;
sub.f32 f214, f110, f181;
sub.f32 f215, f111, f183;
add.f32 f216, f114, f186;
add.f32 f217, f115, f187;
sub.f32 f218, f114, f186;
sub.f32 f219, f115, f187;
add.f32 f220, f118, f190;
add.f32 f221, f119, f192;
sub.f32 f222, f118, f190;
sub.f32 f223, f119, f192;
sub.f32 f224, f108, f166;
add.f32 f225, f109, f165;
add.f32 f226, f108, f166;
sub.f32 f227, f109, f165;
add.f32 f228, f112, f195;
add.f32 f229, f113, f197;
sub.f32 f230, f112, f195;
sub.f32 f231, f113, f197;
add.f32 f232, f116, f200;
add.f32 f233, f117, f202;
sub.f32 f234, f116, f200;
sub.f32 f235, f117, f202;
add.f32 f236, f120, f205;
add.f32 f237, f121, f207;
sub.f32 f238, f120, f205;
sub.f32 f239, f121, f207;
and.b32 r6, r5, 7;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 56;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f240, f241}, [rd5];
mul.f32 f244, f213, f241;
fma.rn.f32 f245, f240, f212, f244;
mul.f32 f246, f212, f241;
mul.f32 f247, f240, f213;
sub.f32 f248, f247, f246;
mul.f32 f249, f240, f240;
mul.f32 f250, f241, f241;
sub.f32 f251, f249, f250;
mul.f32 f252, f241, f240;
fma.rn.f32 f253, f241, f240, f252;
mul.f32 f254, f217, f253;
fma.rn.f32 f255, f251, f216, f254;
mul.f32 f256, f216, f253;
mul.f32 f257, f251, f217;
sub.f32 f258, f257, f256;
mul.f32 f259, f240, f251;
mul.f32 f260, f241, f253;
sub.f32 f261, f259, f260;
mul.f32 f262, f240, f253;
fma.rn.f32 f263, f241, f251, f262;
mul.f32 f264, f221, f263;
fma.rn.f32 f265, f261, f220, f264;
mul.f32 f266, f220, f263;
mul.f32 f267, f261, f221;
sub.f32 f268, f267, f266;
mul.f32 f269, f240, f261;
mul.f32 f270, f241, f263;
sub.f32 f271, f269, f270;
mul.f32 f272, f240, f263;
fma.rn.f32 f273, f241, f261, f272;
mul.f32 f274, f225, f273;
fma.rn.f32 f275, f271, f224, f274;
mul.f32 f276, f224, f273;
mul.f32 f277, f271, f225;
sub.f32 f278, f277, f276;
mul.f32 f279, f240, f271;
mul.f32 f280, f241, f273;
sub.f32 f281, f279, f280;
mul.f32 f282, f240, f273;
fma.rn.f32 f283, f241, f271, f282;
mul.f32 f284, f229, f283;
fma.rn.f32 f285, f281, f228, f284;
mul.f32 f286, f228, f283;
mul.f32 f287, f281, f229;
sub.f32 f288, f287, f286;
mul.f32 f289, f240, f281;
mul.f32 f290, f241, f283;
sub.f32 f291, f289, f290;
mul.f32 f292, f240, f283;
fma.rn.f32 f293, f241, f281, f292;
mul.f32 f294, f233, f293;
fma.rn.f32 f295, f291, f232, f294;
mul.f32 f296, f232, f293;
mul.f32 f297, f291, f233;
sub.f32 f298, f297, f296;
mul.f32 f299, f240, f291;
mul.f32 f300, f241, f293;
sub.f32 f301, f299, f300;
mul.f32 f302, f240, f293;
fma.rn.f32 f303, f241, f291, f302;
mul.f32 f304, f237, f303;
fma.rn.f32 f305, f301, f236, f304;
mul.f32 f306, f236, f303;
mul.f32 f307, f301, f237;
sub.f32 f308, f307, f306;
mul.f32 f309, f240, f301;
mul.f32 f310, f241, f303;
sub.f32 f311, f309, f310;
mul.f32 f312, f240, f303;
fma.rn.f32 f313, f241, f301, f312;
mul.f32 f314, f211, f313;
fma.rn.f32 f315, f311, f210, f314;
mul.f32 f316, f210, f313;
mul.f32 f317, f311, f211;
sub.f32 f318, f317, f316;
mul.f32 f319, f240, f311;
mul.f32 f320, f241, f313;
sub.f32 f321, f319, f320;
mul.f32 f322, f240, f313;
fma.rn.f32 f323, f241, f311, f322;
mul.f32 f324, f215, f323;
fma.rn.f32 f325, f321, f214, f324;
mul.f32 f326, f214, f323;
mul.f32 f327, f321, f215;
sub.f32 f328, f327, f326;
mul.f32 f329, f240, f321;
mul.f32 f330, f241, f323;
sub.f32 f331, f329, f330;
mul.f32 f332, f240, f323;
fma.rn.f32 f333, f241, f321, f332;
mul.f32 f334, f219, f333;
fma.rn.f32 f335, f331, f218, f334;
mul.f32 f336, f218, f333;
mul.f32 f337, f331, f219;
sub.f32 f338, f337, f336;
mul.f32 f339, f240, f331;
mul.f32 f340, f241, f333;
sub.f32 f341, f339, f340;
mul.f32 f342, f240, f333;
fma.rn.f32 f343, f241, f331, f342;
mul.f32 f344, f223, f343;
fma.rn.f32 f345, f341, f222, f344;
mul.f32 f346, f222, f343;
mul.f32 f347, f341, f223;
sub.f32 f348, f347, f346;
mul.f32 f349, f240, f341;
mul.f32 f350, f241, f343;
sub.f32 f351, f349, f350;
mul.f32 f352, f240, f343;
fma.rn.f32 f353, f241, f341, f352;
mul.f32 f354, f227, f353;
fma.rn.f32 f355, f351, f226, f354;
mul.f32 f356, f226, f353;
mul.f32 f357, f351, f227;
sub.f32 f358, f357, f356;
mul.f32 f359, f240, f351;
mul.f32 f360, f241, f353;
sub.f32 f361, f359, f360;
mul.f32 f362, f240, f353;
fma.rn.f32 f363, f241, f351, f362;
mul.f32 f364, f231, f363;
fma.rn.f32 f365, f361, f230, f364;
mul.f32 f366, f230, f363;
mul.f32 f367, f361, f231;
sub.f32 f368, f367, f366;
mul.f32 f369, f240, f361;
mul.f32 f370, f241, f363;
sub.f32 f371, f369, f370;
mul.f32 f372, f240, f363;
fma.rn.f32 f373, f241, f361, f372;
mul.f32 f374, f235, f373;
fma.rn.f32 f375, f371, f234, f374;
mul.f32 f376, f234, f373;
mul.f32 f377, f371, f235;
sub.f32 f378, f377, f376;
mul.f32 f379, f240, f371;
mul.f32 f380, f241, f373;
sub.f32 f381, f379, f380;
mul.f32 f382, f240, f373;
fma.rn.f32 f383, f241, f371, f382;
mul.f32 f384, f239, f383;
fma.rn.f32 f385, f381, f238, f384;
mul.f32 f386, f238, f383;
mul.f32 f387, f381, f239;
sub.f32 f388, f387, f386;
shl.b32 r8, r5, 6;
and.b32 r9, r8, -512;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 448;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f208, f245, f255, f265};
st.shared.v4.f32 [r12+16], {f275, f285, f295, f305};
st.shared.v4.f32 [r12+32], {f315, f325, f335, f345};
st.shared.v4.f32 [r12+48], {f355, f365, f375, f385};
barrier.sync 0;
mad.lo.s32 r13, r6, -60, r12;
ld.shared.f32 f389, [r13];
ld.shared.f32 f390, [r13+32];
ld.shared.f32 f391, [r13+64];
ld.shared.f32 f392, [r13+96];
ld.shared.f32 f393, [r13+128];
ld.shared.f32 f394, [r13+160];
ld.shared.f32 f395, [r13+192];
ld.shared.f32 f396, [r13+224];
ld.shared.f32 f397, [r13+256];
ld.shared.f32 f398, [r13+288];
ld.shared.f32 f399, [r13+320];
ld.shared.f32 f400, [r13+352];
ld.shared.f32 f401, [r13+384];
ld.shared.f32 f402, [r13+416];
ld.shared.f32 f403, [r13+448];
ld.shared.f32 f404, [r13+480];
barrier.sync 0;
st.shared.v4.f32 [r12], {f209, f248, f258, f268};
st.shared.v4.f32 [r12+16], {f278, f288, f298, f308};
st.shared.v4.f32 [r12+32], {f318, f328, f338, f348};
st.shared.v4.f32 [r12+48], {f358, f368, f378, f388};
barrier.sync 0;
ld.shared.f32 f405, [r13];
ld.shared.f32 f406, [r13+32];
ld.shared.f32 f407, [r13+64];
ld.shared.f32 f408, [r13+96];
ld.shared.f32 f409, [r13+128];
ld.shared.f32 f410, [r13+160];
ld.shared.f32 f411, [r13+192];
ld.shared.f32 f412, [r13+224];
ld.shared.f32 f413, [r13+256];
ld.shared.f32 f414, [r13+288];
ld.shared.f32 f415, [r13+320];
ld.shared.f32 f416, [r13+352];
ld.shared.f32 f417, [r13+384];
ld.shared.f32 f418, [r13+416];
ld.shared.f32 f419, [r13+448];
ld.shared.f32 f420, [r13+480];
add.f32 f421, f389, f397;
add.f32 f422, f405, f413;
sub.f32 f423, f389, f397;
sub.f32 f424, f405, f413;
add.f32 f425, f393, f401;
add.f32 f426, f409, f417;
sub.f32 f427, f393, f401;
sub.f32 f428, f409, f417;
add.f32 f429, f421, f425;
add.f32 f430, f422, f426;
sub.f32 f431, f421, f425;
sub.f32 f432, f422, f426;
sub.f32 f433, f423, f428;
add.f32 f434, f424, f427;
add.f32 f435, f423, f428;
sub.f32 f436, f424, f427;
add.f32 f437, f391, f399;
add.f32 f438, f407, f415;
sub.f32 f439, f391, f399;
sub.f32 f440, f407, f415;
add.f32 f441, f395, f403;
add.f32 f442, f411, f419;
sub.f32 f443, f395, f403;
sub.f32 f444, f411, f419;
add.f32 f445, f437, f441;
add.f32 f446, f438, f442;
sub.f32 f447, f437, f441;
sub.f32 f448, f438, f442;
sub.f32 f449, f439, f444;
add.f32 f450, f440, f443;
add.f32 f451, f439, f444;
sub.f32 f452, f440, f443;
mul.f32 f453, f449, 0f3F3504F3;
mul.f32 f454, f450, 0f3F3504F3;
sub.f32 f455, f453, f454;
add.f32 f456, f453, f454;
mul.f32 f457, f451, 0fBF3504F3;
mul.f32 f458, f452, 0f3F3504F3;
sub.f32 f459, f457, f458;
mul.f32 f460, f452, 0fBF3504F3;
fma.rn.f32 f461, f451, 0f3F3504F3, f460;
add.f32 f462, f390, f398;
add.f32 f463, f406, f414;
sub.f32 f464, f390, f398;
sub.f32 f465, f406, f414;
add.f32 f466, f394, f402;
add.f32 f467, f410, f418;
sub.f32 f468, f394, f402;
sub.f32 f469, f410, f418;
add.f32 f470, f462, f466;
add.f32 f471, f463, f467;
sub.f32 f472, f462, f466;
sub.f32 f473, f463, f467;
sub.f32 f474, f464, f469;
add.f32 f475, f465, f468;
add.f32 f476, f464, f469;
sub.f32 f477, f465, f468;
add.f32 f478, f392, f400;
add.f32 f479, f408, f416;
sub.f32 f480, f392, f400;
sub.f32 f481, f408, f416;
add.f32 f482, f396, f404;
add.f32 f483, f412, f420;
sub.f32 f484, f396, f404;
sub.f32 f485, f412, f420;
add.f32 f486, f478, f482;
add.f32 f487, f479, f483;
sub.f32 f488, f478, f482;
sub.f32 f489, f479, f483;
sub.f32 f490, f480, f485;
add.f32 f491, f481, f484;
add.f32 f492, f480, f485;
sub.f32 f493, f481, f484;
mul.f32 f494, f490, 0f3F3504F3;
mul.f32 f495, f491, 0f3F3504F3;
sub.f32 f496, f494, f495;
add.f32 f497, f494, f495;
mul.f32 f498, f492, 0fBF3504F3;
mul.f32 f499, f493, 0f3F3504F3;
sub.f32 f500, f498, f499;
mul.f32 f501, f493, 0fBF3504F3;
fma.rn.f32 f502, f492, 0f3F3504F3, f501;
add.f32 %0, f429, f445;
add.f32 %1, f430, f446;
add.f32 %2, f470, f486;
add.f32 %3, f471, f487;
add.f32 %5, f434, f456;
add.f32 %4, f433, f455;
add.f32 %7, f475, f497;
add.f32 %6, f474, f496;
add.f32 %9, f432, f447;
sub.f32 %8, f431, f448;
add.f32 %11, f473, f488;
sub.f32 %10, f472, f489;
add.f32 %13, f436, f461;
add.f32 %12, f435, f459;
add.f32 %15, f477, f502;
add.f32 %14, f476, f500;
sub.f32 %16, f429, f445;
sub.f32 %17, f430, f446;
sub.f32 %18, f470, f486;
sub.f32 %19, f471, f487;
sub.f32 %21, f434, f456;
sub.f32 %20, f433, f455;
sub.f32 %23, f475, f497;
sub.f32 %22, f474, f496;
sub.f32 %25, f432, f447;
add.f32 %24, f431, f448;
sub.f32 %27, f473, f488;
add.f32 %26, f472, f489;
sub.f32 %29, f436, f461;
sub.f32 %28, f435, f459;
sub.f32 %31, f477, f502;
sub.f32 %30, f476, f500;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y): "r"(smem), "l"(lut_sp_16_128), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<254, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<365>;
.reg .b32 r<20>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 10;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f33, %19, %29;
add.f32 f34, %20, %31;
sub.f32 f35, %19, %29;
sub.f32 f36, %20, %31;
add.f32 f37, %24, %35;
add.f32 f38, %26, %36;
sub.f32 f39, %24, %35;
sub.f32 f40, %26, %36;
add.f32 f41, f33, f37;
add.f32 f42, f34, f38;
sub.f32 f43, f33, f37;
sub.f32 f44, f34, f38;
sub.f32 f45, f35, f40;
add.f32 f46, f36, f39;
add.f32 f47, f35, f40;
sub.f32 f48, f36, f39;
add.f32 f49, %21, %32;
add.f32 f50, %23, %34;
sub.f32 f51, %21, %32;
sub.f32 f52, %23, %34;
add.f32 f53, %27, %37;
add.f32 f54, %28, %38;
sub.f32 f55, %27, %37;
sub.f32 f56, %28, %38;
add.f32 f57, f49, f53;
add.f32 f58, f50, f54;
sub.f32 f59, f49, f53;
sub.f32 f60, f50, f54;
sub.f32 f61, f51, f56;
add.f32 f62, f52, f55;
add.f32 f63, f51, f56;
sub.f32 f64, f52, f55;
mul.f32 f65, f61, 0f3F3504F3;
mul.f32 f66, f62, 0f3F3504F3;
sub.f32 f67, f65, f66;
add.f32 f68, f65, f66;
mul.f32 f69, f63, 0fBF3504F3;
mul.f32 f70, f64, 0f3F3504F3;
sub.f32 f71, f69, f70;
mul.f32 f72, f64, 0fBF3504F3;
fma.rn.f32 f73, f63, 0f3F3504F3, f72;
sub.f32 f74, f41, f57;
sub.f32 f75, f42, f58;
add.f32 f76, f45, f67;
add.f32 f77, f46, f68;
sub.f32 f78, f45, f67;
sub.f32 f79, f46, f68;
sub.f32 f80, f43, f60;
add.f32 f81, f44, f59;
add.f32 f82, f43, f60;
sub.f32 f83, f44, f59;
add.f32 f84, f47, f71;
add.f32 f85, f48, f73;
sub.f32 f86, f47, f71;
sub.f32 f87, f48, f73;
and.b32 r6, r5, 15;
shl.b32 r7, r5, 6;
and.b32 r8, r7, -1024;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 120;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f88, f89}, [rd5];
mul.f32 f92, f77, f89;
mul.f32 f93, f76, f89;
mul.f32 f94, f88, f77;
mul.f32 f95, f88, f88;
mul.f32 f96, f89, f89;
sub.f32 f97, f95, f96;
mul.f32 f98, f89, f88;
fma.rn.f32 f99, f89, f88, f98;
mul.f32 f100, f81, f99;
mul.f32 f101, f80, f99;
mul.f32 f102, f97, f81;
mul.f32 f103, f88, f97;
mul.f32 f104, f89, f99;
sub.f32 f105, f103, f104;
mul.f32 f106, f88, f99;
fma.rn.f32 f107, f89, f97, f106;
mul.f32 f108, f85, f107;
mul.f32 f109, f84, f107;
mul.f32 f110, f105, f85;
mul.f32 f111, f88, f105;
mul.f32 f112, f89, f107;
sub.f32 f113, f111, f112;
mul.f32 f114, f88, f107;
fma.rn.f32 f115, f89, f105, f114;
mul.f32 f116, f75, f115;
mul.f32 f117, f74, f115;
mul.f32 f118, f113, f75;
mul.f32 f119, f88, f113;
mul.f32 f120, f89, f115;
sub.f32 f121, f119, f120;
mul.f32 f122, f88, f115;
fma.rn.f32 f123, f89, f113, f122;
mul.f32 f124, f79, f123;
mul.f32 f125, f78, f123;
mul.f32 f126, f121, f79;
mul.f32 f127, f88, f121;
mul.f32 f128, f89, f123;
sub.f32 f129, f127, f128;
mul.f32 f130, f88, f123;
fma.rn.f32 f131, f89, f121, f130;
mul.f32 f132, f83, f131;
mul.f32 f133, f82, f131;
mul.f32 f134, f129, f83;
mul.f32 f135, f88, f129;
mul.f32 f136, f89, f131;
sub.f32 f137, f135, f136;
mul.f32 f138, f88, f131;
fma.rn.f32 f139, f89, f129, f138;
mul.f32 f140, f87, f139;
mul.f32 f141, f86, f139;
mul.f32 f142, f137, f87;
barrier.sync 0;
and.b32 r11, r7, 960;
add.s32 r12, r9, r11;
add.f32 f143, f42, f58;
add.f32 f144, f41, f57;
fma.rn.f32 f145, f88, f76, f92;
sub.f32 f146, f94, f93;
st.shared.v4.f32 [r12], {f144, f143, f145, f146};
fma.rn.f32 f147, f97, f80, f100;
sub.f32 f148, f102, f101;
sub.f32 f149, f110, f109;
fma.rn.f32 f150, f105, f84, f108;
st.shared.v4.f32 [r12+16], {f147, f148, f150, f149};
fma.rn.f32 f151, f113, f74, f116;
sub.f32 f152, f118, f117;
fma.rn.f32 f153, f121, f78, f124;
sub.f32 f154, f126, f125;
st.shared.v4.f32 [r12+32], {f151, f152, f153, f154};
fma.rn.f32 f155, f129, f82, f132;
sub.f32 f156, f134, f133;
fma.rn.f32 f157, f137, f86, f140;
sub.f32 f158, f142, f141;
st.shared.v4.f32 [r12+48], {f155, f156, f157, f158};
barrier.sync 0;
mad.lo.s32 r13, r6, -56, r12;
ld.shared.v2.f32 {f159, f160}, [r13];
ld.shared.v2.f32 {f163, f164}, [r13+128];
ld.shared.v2.f32 {f167, f168}, [r13+256];
ld.shared.v2.f32 {f171, f172}, [r13+384];
ld.shared.v2.f32 {f175, f176}, [r13+512];
ld.shared.v2.f32 {f179, f180}, [r13+640];
ld.shared.v2.f32 {f183, f184}, [r13+768];
ld.shared.v2.f32 {f187, f188}, [r13+896];
add.f32 f191, f159, f175;
add.f32 f192, f160, f176;
sub.f32 f193, f159, f175;
sub.f32 f194, f160, f176;
add.f32 f195, f167, f183;
add.f32 f196, f168, f184;
sub.f32 f197, f167, f183;
sub.f32 f198, f168, f184;
add.f32 f199, f191, f195;
add.f32 f200, f192, f196;
sub.f32 f201, f191, f195;
sub.f32 f202, f192, f196;
sub.f32 f203, f193, f198;
add.f32 f204, f194, f197;
add.f32 f205, f193, f198;
sub.f32 f206, f194, f197;
add.f32 f207, f163, f179;
add.f32 f208, f164, f180;
sub.f32 f209, f163, f179;
sub.f32 f210, f164, f180;
add.f32 f211, f171, f187;
add.f32 f212, f172, f188;
sub.f32 f213, f171, f187;
sub.f32 f214, f172, f188;
add.f32 f215, f207, f211;
add.f32 f216, f208, f212;
sub.f32 f217, f207, f211;
sub.f32 f218, f208, f212;
sub.f32 f219, f209, f214;
add.f32 f220, f210, f213;
add.f32 f221, f209, f214;
sub.f32 f222, f210, f213;
mul.f32 f223, f219, 0f3F3504F3;
mul.f32 f224, f220, 0f3F3504F3;
sub.f32 f225, f223, f224;
add.f32 f226, f223, f224;
mul.f32 f227, f221, 0fBF3504F3;
mul.f32 f228, f222, 0f3F3504F3;
sub.f32 f229, f227, f228;
mul.f32 f230, f222, 0fBF3504F3;
fma.rn.f32 f231, f221, 0f3F3504F3, f230;
sub.f32 f232, f199, f215;
sub.f32 f233, f200, f216;
add.f32 f234, f203, f225;
add.f32 f235, f204, f226;
sub.f32 f236, f203, f225;
sub.f32 f237, f204, f226;
sub.f32 f238, f201, f218;
add.f32 f239, f202, f217;
add.f32 f240, f201, f218;
sub.f32 f241, f202, f217;
add.f32 f242, f205, f229;
add.f32 f243, f206, f231;
sub.f32 f244, f205, f229;
sub.f32 f245, f206, f231;
and.b32 r14, r5, 8;
cvt.u64.u32 rd6, r14;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f246, f247}, [rd8];
mul.f32 f250, f235, f247;
mul.f32 f251, f234, f247;
mul.f32 f252, f246, f235;
mul.f32 f253, f246, f246;
mul.f32 f254, f247, f247;
sub.f32 f255, f253, f254;
mul.f32 f256, f247, f246;
fma.rn.f32 f257, f247, f246, f256;
mul.f32 f258, f239, f257;
mul.f32 f259, f238, f257;
mul.f32 f260, f255, f239;
mul.f32 f261, f246, f255;
mul.f32 f262, f247, f257;
sub.f32 f263, f261, f262;
mul.f32 f264, f246, f257;
fma.rn.f32 f265, f247, f255, f264;
mul.f32 f266, f243, f265;
mul.f32 f267, f242, f265;
mul.f32 f268, f263, f243;
mul.f32 f269, f246, f263;
mul.f32 f270, f247, f265;
sub.f32 f271, f269, f270;
mul.f32 f272, f246, f265;
fma.rn.f32 f273, f247, f263, f272;
mul.f32 f274, f233, f273;
mul.f32 f275, f232, f273;
mul.f32 f276, f271, f233;
mul.f32 f277, f246, f271;
mul.f32 f278, f247, f273;
sub.f32 f279, f277, f278;
mul.f32 f280, f246, f273;
fma.rn.f32 f281, f247, f271, f280;
mul.f32 f282, f237, f281;
mul.f32 f283, f236, f281;
mul.f32 f284, f279, f237;
mul.f32 f285, f246, f279;
mul.f32 f286, f247, f281;
sub.f32 f287, f285, f286;
mul.f32 f288, f246, f281;
fma.rn.f32 f289, f247, f279, f288;
mul.f32 f290, f241, f289;
mul.f32 f291, f240, f289;
mul.f32 f292, f287, f241;
mul.f32 f293, f246, f287;
mul.f32 f294, f247, f289;
sub.f32 f295, f293, f294;
mul.f32 f296, f246, f289;
fma.rn.f32 f297, f247, f287, f296;
mul.f32 f298, f245, f297;
mul.f32 f299, f244, f297;
mul.f32 f300, f295, f245;
and.b32 r15, r10, 56;
add.s32 r16, r9, r15;
barrier.sync 0;
and.b32 r17, r7, 512;
add.s32 r18, r16, r17;
add.f32 f301, f200, f216;
add.f32 f302, f199, f215;
st.shared.v2.f32 [r18], {f302, f301};
fma.rn.f32 f303, f246, f234, f250;
sub.f32 f304, f252, f251;
st.shared.v2.f32 [r18+64], {f303, f304};
fma.rn.f32 f305, f255, f238, f258;
sub.f32 f306, f260, f259;
st.shared.v2.f32 [r18+128], {f305, f306};
fma.rn.f32 f307, f263, f242, f266;
sub.f32 f308, f268, f267;
st.shared.v2.f32 [r18+192], {f307, f308};
sub.f32 f309, f276, f275;
fma.rn.f32 f310, f271, f232, f274;
st.shared.v2.f32 [r18+256], {f310, f309};
fma.rn.f32 f311, f279, f236, f282;
sub.f32 f312, f284, f283;
st.shared.v2.f32 [r18+320], {f311, f312};
fma.rn.f32 f313, f287, f240, f290;
sub.f32 f314, f292, f291;
st.shared.v2.f32 [r18+384], {f313, f314};
fma.rn.f32 f315, f295, f244, f298;
sub.f32 f316, f300, f299;
st.shared.v2.f32 [r18+448], {f315, f316};
barrier.sync 0;
mad.lo.s32 r19, r14, -56, r18;
ld.shared.v2.f32 {f317, f318}, [r19];
ld.shared.v2.f32 {f321, f322}, [r19+128];
ld.shared.v2.f32 {f325, f326}, [r19+256];
ld.shared.v2.f32 {f329, f330}, [r19+384];
ld.shared.v2.f32 {f333, f334}, [r19+512];
ld.shared.v2.f32 {f337, f338}, [r19+640];
ld.shared.v2.f32 {f341, f342}, [r19+768];
ld.shared.v2.f32 {f345, f346}, [r19+896];
add.f32 %1, f318, f334;
add.f32 %0, f317, f333;
add.f32 %3, f322, f338;
add.f32 %2, f321, f337;
add.f32 %5, f326, f342;
add.f32 %4, f325, f341;
add.f32 %7, f330, f346;
add.f32 %6, f329, f345;
sub.f32 %9, f318, f334;
sub.f32 %8, f317, f333;
sub.f32 %11, f322, f338;
sub.f32 %10, f321, f337;
sub.f32 %13, f326, f342;
sub.f32 %12, f325, f341;
sub.f32 %15, f330, f346;
sub.f32 %14, f329, f345;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y): "r"(smem), "l"(lut_sp_8_128), "l"(lut_sp_8_16), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<255, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<690>;
.reg .b32 r<20>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 10;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
add.f32 f65, %34, %50;
sub.f32 f67, %34, %50;
add.f32 f684, %35, %66;
sub.f32 f68, %35, %66;
add.f32 f69, %42, %58;
sub.f32 f71, %42, %58;
add.f32 f682, %67, %59;
sub.f32 f72, %67, %59;
add.f32 f73, f65, f69;
sub.f32 f75, f65, f69;
add.f32 f681, f684, f682;
sub.f32 f76, f684, f682;
sub.f32 f77, f67, f72;
add.f32 f79, f67, f72;
add.f32 f680, f68, f71;
sub.f32 f80, f68, f71;
add.f32 f81, %38, %54;
sub.f32 f83, %38, %54;
add.f32 f677, %69, %68;
sub.f32 f84, %69, %68;
add.f32 f85, %46, %62;
sub.f32 f87, %46, %62;
add.f32 f675, %47, %70;
sub.f32 f88, %47, %70;
add.f32 f89, f81, f85;
sub.f32 f91, f81, f85;
add.f32 f674, f677, f675;
sub.f32 f92, f677, f675;
sub.f32 f93, f83, f88;
add.f32 f95, f83, f88;
add.f32 f673, f84, f87;
sub.f32 f96, f84, f87;
mul.f32 f97, f93, 0f3F3504F3;
mul.f32 f98, f673, 0f3F3504F3;
sub.f32 f99, f97, f98;
add.f32 f100, f97, f98;
mul.f32 f671, f95, 0fBF3504F3;
mul.f32 f672, f96, 0f3F3504F3;
sub.f32 f103, f671, f672;
mul.f32 f104, f96, 0fBF3504F3;
fma.rn.f32 f105, f95, 0f3F3504F3, f104;
add.f32 f106, f73, f89;
sub.f32 f108, f73, f89;
add.f32 f670, f681, f674;
sub.f32 f109, f681, f674;
add.f32 f110, f77, f99;
sub.f32 f112, f77, f99;
add.f32 f669, f680, f100;
sub.f32 f113, f680, f100;
sub.f32 f114, f75, f92;
add.f32 f116, f75, f92;
add.f32 f668, f76, f91;
sub.f32 f117, f76, f91;
add.f32 f118, f79, f103;
sub.f32 f120, f79, f103;
add.f32 f667, f80, f105;
sub.f32 f121, f80, f105;
add.f32 f122, %36, %52;
sub.f32 f124, %36, %52;
add.f32 f665, %71, %53;
sub.f32 f125, %71, %53;
add.f32 f126, %44, %60;
sub.f32 f128, %44, %60;
add.f32 f662, %72, %73;
sub.f32 f129, %72, %73;
add.f32 f130, f122, f126;
sub.f32 f132, f122, f126;
add.f32 f661, f665, f662;
sub.f32 f133, f665, f662;
sub.f32 f134, f124, f129;
add.f32 f136, f124, f129;
add.f32 f660, f125, f128;
sub.f32 f137, f125, f128;
add.f32 f138, %40, %56;
sub.f32 f140, %40, %56;
add.f32 f658, %41, %74;
sub.f32 f141, %41, %74;
add.f32 f142, %48, %64;
sub.f32 f144, %48, %64;
add.f32 f656, %75, %65;
sub.f32 f145, %75, %65;
add.f32 f146, f138, f142;
sub.f32 f148, f138, f142;
add.f32 f655, f658, f656;
sub.f32 f149, f658, f656;
sub.f32 f150, f140, f145;
add.f32 f152, f140, f145;
add.f32 f654, f141, f144;
sub.f32 f153, f141, f144;
mul.f32 f154, f150, 0f3F3504F3;
mul.f32 f155, f654, 0f3F3504F3;
sub.f32 f156, f154, f155;
add.f32 f157, f154, f155;
mul.f32 f652, f152, 0fBF3504F3;
mul.f32 f653, f153, 0f3F3504F3;
sub.f32 f160, f652, f653;
mul.f32 f161, f153, 0fBF3504F3;
fma.rn.f32 f162, f152, 0f3F3504F3, f161;
add.f32 f163, f130, f146;
sub.f32 f165, f130, f146;
add.f32 f651, f661, f655;
sub.f32 f166, f661, f655;
add.f32 f167, f134, f156;
sub.f32 f169, f134, f156;
add.f32 f650, f660, f157;
sub.f32 f170, f660, f157;
sub.f32 f171, f132, f149;
add.f32 f173, f132, f149;
add.f32 f649, f133, f148;
sub.f32 f174, f133, f148;
add.f32 f175, f136, f160;
sub.f32 f177, f136, f160;
add.f32 f648, f137, f162;
sub.f32 f178, f137, f162;
mul.f32 f646, f167, 0f3F6C835E;
mul.f32 f647, f650, 0f3EC3EF15;
sub.f32 f181, f646, f647;
mul.f32 f182, f650, 0f3F6C835E;
fma.rn.f32 f183, f167, 0f3EC3EF15, f182;
mul.f32 f184, f171, 0f3F3504F3;
mul.f32 f185, f649, 0f3F3504F3;
sub.f32 f186, f184, f185;
add.f32 f187, f184, f185;
mul.f32 f189, f648, 0f3F6C835E;
mul.f32 f645, f175, 0f3EC3EF15;
sub.f32 f190, f645, f189;
mul.f32 f191, f648, 0f3EC3EF15;
fma.rn.f32 f192, f175, 0f3F6C835E, f191;
mul.f32 f194, f170, 0f3F6C835E;
mul.f32 f644, f169, 0fBEC3EF15;
sub.f32 f195, f644, f194;
mul.f32 f196, f170, 0fBEC3EF15;
fma.rn.f32 f197, f169, 0f3F6C835E, f196;
mul.f32 f642, f173, 0fBF3504F3;
mul.f32 f643, f174, 0f3F3504F3;
sub.f32 f200, f642, f643;
mul.f32 f201, f174, 0fBF3504F3;
fma.rn.f32 f202, f173, 0f3F3504F3, f201;
mul.f32 f640, f177, 0fBF6C835E;
mul.f32 f641, f178, 0f3EC3EF15;
sub.f32 f205, f640, f641;
mul.f32 f206, f178, 0fBF6C835E;
fma.rn.f32 f207, f177, 0f3EC3EF15, f206;
add.f32 f210, f110, f181;
sub.f32 f212, f110, f181;
add.f32 f639, f669, f183;
sub.f32 f213, f669, f183;
add.f32 f214, f114, f186;
sub.f32 f216, f114, f186;
add.f32 f638, f668, f187;
sub.f32 f217, f668, f187;
add.f32 f218, f118, f190;
sub.f32 f220, f118, f190;
add.f32 f637, f667, f192;
sub.f32 f221, f667, f192;
sub.f32 f222, f108, f166;
add.f32 f224, f108, f166;
add.f32 f636, f109, f165;
sub.f32 f225, f109, f165;
add.f32 f226, f112, f195;
sub.f32 f228, f112, f195;
add.f32 f635, f113, f197;
sub.f32 f229, f113, f197;
add.f32 f230, f116, f200;
sub.f32 f232, f116, f200;
add.f32 f634, f117, f202;
sub.f32 f233, f117, f202;
add.f32 f234, f120, f205;
sub.f32 f236, f120, f205;
add.f32 f633, f121, f207;
sub.f32 f237, f121, f207;
mov.u32 r15, %tid.x;
shl.b32 r7, r15, 7;
and.b32 r8, r7, -1024;
add.s32 r9, r4, r8;
and.b32 r14, r15, 7;
shl.b32 r10, r15, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 56;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f238, f239}, [rd5];
mul.f32 f242, f639, f239;
mul.f32 f244, f238, f639;
mul.f32 f246, f239, f239;
mul.f32 f632, f238, f238;
sub.f32 f247, f632, f246;
mul.f32 f248, f239, f238;
fma.rn.f32 f249, f239, f238, f248;
mul.f32 f250, f638, f249;
mul.f32 f252, f247, f638;
mul.f32 f630, f238, f247;
mul.f32 f631, f239, f249;
sub.f32 f255, f630, f631;
mul.f32 f629, f214, f249;
mul.f32 f256, f238, f249;
fma.rn.f32 f257, f239, f247, f256;
mul.f32 f258, f637, f257;
mul.f32 f260, f255, f637;
mul.f32 f262, f239, f257;
mul.f32 f628, f238, f255;
sub.f32 f263, f628, f262;
mul.f32 f627, f218, f257;
mul.f32 f264, f238, f257;
fma.rn.f32 f265, f239, f255, f264;
mul.f32 f266, f636, f265;
mul.f32 f268, f263, f636;
mul.f32 f270, f239, f265;
mul.f32 f626, f238, f263;
sub.f32 f271, f626, f270;
mul.f32 f625, f222, f265;
mul.f32 f272, f238, f265;
fma.rn.f32 f273, f239, f263, f272;
mul.f32 f274, f635, f273;
mul.f32 f276, f271, f635;
mul.f32 f623, f238, f271;
mul.f32 f624, f239, f273;
sub.f32 f279, f623, f624;
mul.f32 f622, f226, f273;
mul.f32 f280, f238, f273;
fma.rn.f32 f281, f239, f271, f280;
mul.f32 f282, f634, f281;
mul.f32 f284, f279, f634;
mul.f32 f286, f239, f281;
mul.f32 f621, f238, f279;
sub.f32 f287, f621, f286;
mul.f32 f620, f230, f281;
mul.f32 f288, f238, f281;
fma.rn.f32 f289, f239, f279, f288;
mul.f32 f290, f633, f289;
mul.f32 f292, f287, f633;
mul.f32 f294, f239, f289;
mul.f32 f619, f238, f287;
sub.f32 f295, f619, f294;
mul.f32 f618, f234, f289;
mul.f32 f296, f238, f289;
fma.rn.f32 f297, f239, f287, f296;
sub.f32 f617, f670, f651;
mul.f32 f298, f617, f297;
mul.f32 f300, f295, f617;
mul.f32 f615, f238, f295;
mul.f32 f616, f239, f297;
sub.f32 f303, f615, f616;
sub.f32 f614, f106, f163;
mul.f32 f613, f614, f297;
mul.f32 f304, f238, f297;
fma.rn.f32 f305, f239, f295, f304;
mul.f32 f306, f213, f305;
mul.f32 f308, f303, f213;
mul.f32 f310, f239, f305;
mul.f32 f612, f238, f303;
sub.f32 f311, f612, f310;
mul.f32 f611, f212, f305;
mul.f32 f312, f238, f305;
fma.rn.f32 f313, f239, f303, f312;
mul.f32 f314, f217, f313;
mul.f32 f316, f311, f217;
mul.f32 f609, f238, f311;
mul.f32 f610, f239, f313;
sub.f32 f319, f609, f610;
mul.f32 f608, f216, f313;
mul.f32 f320, f238, f313;
fma.rn.f32 f321, f239, f311, f320;
mul.f32 f322, f221, f321;
mul.f32 f324, f319, f221;
mul.f32 f326, f239, f321;
mul.f32 f607, f238, f319;
sub.f32 f327, f607, f326;
mul.f32 f606, f220, f321;
mul.f32 f328, f238, f321;
fma.rn.f32 f329, f239, f319, f328;
mul.f32 f330, f225, f329;
mul.f32 f332, f327, f225;
mul.f32 f334, f239, f329;
mul.f32 f605, f238, f327;
sub.f32 f335, f605, f334;
mul.f32 f604, f224, f329;
mul.f32 f336, f238, f329;
fma.rn.f32 f337, f239, f327, f336;
mul.f32 f338, f229, f337;
mul.f32 f340, f335, f229;
mul.f32 f602, f238, f335;
mul.f32 f603, f239, f337;
sub.f32 f343, f602, f603;
mul.f32 f601, f228, f337;
mul.f32 f344, f238, f337;
fma.rn.f32 f345, f239, f335, f344;
mul.f32 f346, f233, f345;
mul.f32 f348, f343, f233;
mul.f32 f350, f239, f345;
mul.f32 f600, f238, f343;
sub.f32 f351, f600, f350;
mul.f32 f599, f232, f345;
mul.f32 f352, f238, f345;
mul.f32 f598, f210, f239;
fma.rn.f32 f353, f239, f343, f352;
mul.f32 f354, f237, f353;
mul.f32 f355, f236, f353;
mul.f32 f356, f351, f237;
barrier.sync 0;
and.b32 r11, r7, 896;
add.s32 r12, r9, r11;
sub.f32 f689, f670, f651;
mul.f32 f688, f295, f689;
add.f32 f357, f670, f651;
sub.f32 f687, f106, f163;
add.f32 f358, f106, f163;
mov.u32 r17, %tid.x;
and.b32 r16, r17, 7;
mov.u32 r19, %tid.x;
and.b32 r18, r19, 7;
fma.rn.f32 f359, f238, f210, f242;
sub.f32 f360, f244, f598;
st.shared.v4.f32 [r12], {f358, f357, f359, f360};
fma.rn.f32 f361, f247, f214, f250;
sub.f32 f362, f252, f629;
fma.rn.f32 f363, f255, f218, f258;
sub.f32 f364, f260, f627;
st.shared.v4.f32 [r12+16], {f361, f362, f363, f364};
sub.f32 f365, f268, f625;
fma.rn.f32 f366, f263, f222, f266;
fma.rn.f32 f367, f271, f226, f274;
sub.f32 f368, f276, f622;
st.shared.v4.f32 [r12+32], {f366, f365, f367, f368};
fma.rn.f32 f369, f279, f230, f282;
sub.f32 f370, f284, f620;
fma.rn.f32 f371, f287, f234, f290;
sub.f32 f372, f292, f618;
st.shared.v4.f32 [r12+48], {f369, f370, f371, f372};
fma.rn.f32 f373, f295, f687, f298;
sub.f32 f374, f688, f613;
fma.rn.f32 f375, f303, f212, f306;
sub.f32 f376, f308, f611;
st.shared.v4.f32 [r12+64], {f373, f374, f375, f376};
fma.rn.f32 f377, f311, f216, f314;
sub.f32 f378, f316, f608;
fma.rn.f32 f379, f319, f220, f322;
sub.f32 f380, f324, f606;
st.shared.v4.f32 [r12+80], {f377, f378, f379, f380};
fma.rn.f32 f381, f327, f224, f330;
sub.f32 f382, f332, f604;
fma.rn.f32 f383, f335, f228, f338;
sub.f32 f384, f340, f601;
st.shared.v4.f32 [r12+96], {f381, f382, f383, f384};
fma.rn.f32 f385, f343, f232, f346;
sub.f32 f386, f348, f599;
fma.rn.f32 f387, f351, f236, f354;
sub.f32 f388, f356, f355;
st.shared.v4.f32 [r12+112], {f385, f386, f387, f388};
barrier.sync 0;
mad.lo.s32 r13, r18, -120, r12;
ld.shared.v2.f32 {f389, f390}, [r13];
ld.shared.v2.f32 {f393, f394}, [r13+64];
ld.shared.v2.f32 {f397, f398}, [r13+128];
ld.shared.v2.f32 {f401, f402}, [r13+192];
ld.shared.v2.f32 {f405, f406}, [r13+256];
ld.shared.v2.f32 {f409, f410}, [r13+320];
ld.shared.v2.f32 {f413, f414}, [r13+384];
ld.shared.v2.f32 {f417, f418}, [r13+448];
ld.shared.v2.f32 {f421, f422}, [r13+512];
ld.shared.v2.f32 {f425, f426}, [r13+576];
ld.shared.v2.f32 {f429, f430}, [r13+640];
ld.shared.v2.f32 {f433, f434}, [r13+704];
ld.shared.v2.f32 {f437, f438}, [r13+768];
ld.shared.v2.f32 {f441, f442}, [r13+832];
ld.shared.v2.f32 {f445, f446}, [r13+896];
ld.shared.v2.f32 {f449, f450}, [r13+960];
add.f32 f453, f389, f421;
sub.f32 f455, f389, f421;
add.f32 f597, f390, f422;
sub.f32 f456, f390, f422;
add.f32 f457, f405, f437;
sub.f32 f459, f405, f437;
add.f32 f596, f406, f438;
sub.f32 f460, f406, f438;
add.f32 f461, f453, f457;
sub.f32 f463, f453, f457;
add.f32 f595, f597, f596;
sub.f32 f464, f597, f596;
sub.f32 f465, f455, f460;
add.f32 f467, f455, f460;
add.f32 f594, f456, f459;
sub.f32 f468, f456, f459;
add.f32 f469, f397, f429;
sub.f32 f471, f397, f429;
add.f32 f593, f398, f430;
sub.f32 f472, f398, f430;
add.f32 f473, f413, f445;
sub.f32 f475, f413, f445;
add.f32 f592, f414, f446;
sub.f32 f476, f414, f446;
add.f32 f477, f469, f473;
sub.f32 f479, f469, f473;
add.f32 f591, f593, f592;
sub.f32 f480, f593, f592;
sub.f32 f481, f471, f476;
add.f32 f483, f471, f476;
add.f32 f590, f472, f475;
sub.f32 f484, f472, f475;
mul.f32 f485, f481, 0f3F3504F3;
mul.f32 f486, f590, 0f3F3504F3;
sub.f32 f487, f485, f486;
add.f32 f488, f485, f486;
mul.f32 f490, f484, 0f3F3504F3;
mul.f32 f589, f483, 0fBF3504F3;
sub.f32 f491, f589, f490;
mul.f32 f492, f484, 0fBF3504F3;
fma.rn.f32 f493, f483, 0f3F3504F3, f492;
add.f32 f494, f393, f425;
sub.f32 f496, f393, f425;
add.f32 f588, f394, f426;
sub.f32 f497, f394, f426;
add.f32 f498, f409, f441;
sub.f32 f500, f409, f441;
add.f32 f587, f410, f442;
sub.f32 f501, f410, f442;
add.f32 f502, f494, f498;
sub.f32 f504, f494, f498;
add.f32 f586, f588, f587;
sub.f32 f505, f588, f587;
sub.f32 f506, f496, f501;
add.f32 f508, f496, f501;
add.f32 f585, f497, f500;
sub.f32 f509, f497, f500;
add.f32 f510, f401, f433;
sub.f32 f512, f401, f433;
add.f32 f584, f402, f434;
sub.f32 f513, f402, f434;
add.f32 f514, f417, f449;
sub.f32 f516, f417, f449;
add.f32 f583, f418, f450;
sub.f32 f517, f418, f450;
add.f32 f518, f510, f514;
sub.f32 f520, f510, f514;
add.f32 f582, f584, f583;
sub.f32 f521, f584, f583;
sub.f32 f522, f512, f517;
add.f32 f524, f512, f517;
add.f32 f581, f513, f516;
sub.f32 f525, f513, f516;
mul.f32 f526, f522, 0f3F3504F3;
mul.f32 f527, f581, 0f3F3504F3;
sub.f32 f528, f526, f527;
add.f32 f529, f526, f527;
mul.f32 f579, f524, 0fBF3504F3;
mul.f32 f580, f525, 0f3F3504F3;
sub.f32 f532, f579, f580;
mul.f32 f533, f525, 0fBF3504F3;
fma.rn.f32 f534, f524, 0f3F3504F3, f533;
add.f32 %1, f595, f591;
add.f32 %0, f461, f477;
add.f32 %3, f586, f582;
add.f32 %2, f502, f518;
add.f32 %4, f465, f487;
add.f32 %5, f594, f488;
add.f32 %6, f506, f528;
add.f32 %7, f585, f529;
sub.f32 %8, f463, f480;
add.f32 %9, f464, f479;
sub.f32 %10, f504, f521;
add.f32 %11, f505, f520;
add.f32 %13, f468, f493;
add.f32 %12, f467, f491;
add.f32 %15, f509, f534;
add.f32 %14, f508, f532;
sub.f32 %17, f595, f591;
sub.f32 %16, f461, f477;
sub.f32 %19, f586, f582;
sub.f32 %18, f502, f518;
sub.f32 %21, f594, f488;
sub.f32 %20, f465, f487;
sub.f32 %23, f585, f529;
sub.f32 %22, f506, f528;
sub.f32 %25, f464, f479;
add.f32 %24, f463, f480;
sub.f32 %27, f505, f520;
add.f32 %26, f504, f521;
sub.f32 %29, f468, f493;
sub.f32 %28, f467, f491;
sub.f32 %31, f509, f534;
sub.f32 %30, f508, f532;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y): "r"(smem), "l"(lut_sp_16_128), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[8].y), "f"(rmem[4].y), "f"(rmem[10].y), "f"(rmem[2].y), "f"(rmem[14].y), "f"(rmem[1].y), "f"(rmem[5].y), "f"(rmem[13].y), "f"(rmem[11].y), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<256, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<333>;
.reg .b32 r<21>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 9;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f33, %19, %29;
add.f32 f34, %20, %31;
sub.f32 f35, %19, %29;
sub.f32 f36, %20, %31;
add.f32 f37, %24, %35;
add.f32 f38, %26, %36;
sub.f32 f39, %24, %35;
sub.f32 f40, %26, %36;
add.f32 f41, f33, f37;
add.f32 f42, f34, f38;
sub.f32 f43, f33, f37;
sub.f32 f44, f34, f38;
sub.f32 f45, f35, f40;
add.f32 f46, f36, f39;
add.f32 f47, f35, f40;
sub.f32 f48, f36, f39;
add.f32 f49, %21, %32;
add.f32 f50, %23, %34;
sub.f32 f51, %21, %32;
sub.f32 f52, %23, %34;
add.f32 f53, %27, %37;
add.f32 f54, %28, %38;
sub.f32 f55, %27, %37;
sub.f32 f56, %28, %38;
add.f32 f57, f49, f53;
add.f32 f58, f50, f54;
sub.f32 f59, f49, f53;
sub.f32 f60, f50, f54;
sub.f32 f61, f51, f56;
add.f32 f62, f52, f55;
add.f32 f63, f51, f56;
sub.f32 f64, f52, f55;
mul.f32 f65, f61, 0f3F3504F3;
mul.f32 f66, f62, 0f3F3504F3;
sub.f32 f67, f65, f66;
add.f32 f68, f65, f66;
mul.f32 f69, f63, 0fBF3504F3;
mul.f32 f70, f64, 0f3F3504F3;
sub.f32 f71, f69, f70;
mul.f32 f72, f64, 0fBF3504F3;
fma.rn.f32 f73, f63, 0f3F3504F3, f72;
add.f32 f74, f41, f57;
add.f32 f75, f42, f58;
sub.f32 f76, f41, f57;
sub.f32 f77, f42, f58;
add.f32 f78, f45, f67;
add.f32 f79, f46, f68;
sub.f32 f80, f45, f67;
sub.f32 f81, f46, f68;
sub.f32 f82, f43, f60;
add.f32 f83, f44, f59;
add.f32 f84, f43, f60;
sub.f32 f85, f44, f59;
add.f32 f86, f47, f71;
add.f32 f87, f48, f73;
sub.f32 f88, f47, f71;
sub.f32 f89, f48, f73;
and.b32 r6, r5, 15;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 120;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f90, f91}, [rd5];
mul.f32 f94, f79, f91;
fma.rn.f32 f95, f90, f78, f94;
mul.f32 f96, f78, f91;
mul.f32 f97, f90, f79;
sub.f32 f98, f97, f96;
mul.f32 f99, f90, f90;
mul.f32 f100, f91, f91;
sub.f32 f101, f99, f100;
mul.f32 f102, f91, f90;
fma.rn.f32 f103, f91, f90, f102;
mul.f32 f104, f83, f103;
fma.rn.f32 f105, f101, f82, f104;
mul.f32 f106, f82, f103;
mul.f32 f107, f101, f83;
sub.f32 f108, f107, f106;
mul.f32 f109, f90, f101;
mul.f32 f110, f91, f103;
sub.f32 f111, f109, f110;
mul.f32 f112, f90, f103;
fma.rn.f32 f113, f91, f101, f112;
mul.f32 f114, f87, f113;
fma.rn.f32 f115, f111, f86, f114;
mul.f32 f116, f86, f113;
mul.f32 f117, f111, f87;
sub.f32 f118, f117, f116;
mul.f32 f119, f90, f111;
mul.f32 f120, f91, f113;
sub.f32 f121, f119, f120;
mul.f32 f122, f90, f113;
fma.rn.f32 f123, f91, f111, f122;
mul.f32 f124, f77, f123;
fma.rn.f32 f125, f121, f76, f124;
mul.f32 f126, f76, f123;
mul.f32 f127, f121, f77;
sub.f32 f128, f127, f126;
mul.f32 f129, f90, f121;
mul.f32 f130, f91, f123;
sub.f32 f131, f129, f130;
mul.f32 f132, f90, f123;
fma.rn.f32 f133, f91, f121, f132;
mul.f32 f134, f81, f133;
fma.rn.f32 f135, f131, f80, f134;
mul.f32 f136, f80, f133;
mul.f32 f137, f131, f81;
sub.f32 f138, f137, f136;
mul.f32 f139, f90, f131;
mul.f32 f140, f91, f133;
sub.f32 f141, f139, f140;
mul.f32 f142, f90, f133;
fma.rn.f32 f143, f91, f131, f142;
mul.f32 f144, f85, f143;
fma.rn.f32 f145, f141, f84, f144;
mul.f32 f146, f84, f143;
mul.f32 f147, f141, f85;
sub.f32 f148, f147, f146;
mul.f32 f149, f90, f141;
mul.f32 f150, f91, f143;
sub.f32 f151, f149, f150;
mul.f32 f152, f90, f143;
fma.rn.f32 f153, f91, f141, f152;
mul.f32 f154, f89, f153;
fma.rn.f32 f155, f151, f88, f154;
mul.f32 f156, f88, f153;
mul.f32 f157, f151, f89;
sub.f32 f158, f157, f156;
shl.b32 r8, r5, 5;
and.b32 r9, r8, -512;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 480;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f74, f95, f105, f115};
st.shared.v4.f32 [r12+16], {f125, f135, f145, f155};
barrier.sync 0;
mad.lo.s32 r13, r6, -28, r12;
ld.shared.f32 f159, [r13];
ld.shared.f32 f160, [r13+64];
ld.shared.f32 f161, [r13+128];
ld.shared.f32 f162, [r13+192];
ld.shared.f32 f163, [r13+256];
ld.shared.f32 f164, [r13+320];
ld.shared.f32 f165, [r13+384];
ld.shared.f32 f166, [r13+448];
barrier.sync 0;
st.shared.v4.f32 [r12], {f75, f98, f108, f118};
st.shared.v4.f32 [r12+16], {f128, f138, f148, f158};
barrier.sync 0;
ld.shared.f32 f167, [r13];
ld.shared.f32 f168, [r13+64];
ld.shared.f32 f169, [r13+128];
ld.shared.f32 f170, [r13+192];
ld.shared.f32 f171, [r13+256];
ld.shared.f32 f172, [r13+320];
ld.shared.f32 f173, [r13+384];
ld.shared.f32 f174, [r13+448];
add.f32 f175, f159, f163;
add.f32 f176, f167, f171;
sub.f32 f177, f159, f163;
sub.f32 f178, f167, f171;
add.f32 f179, f161, f165;
add.f32 f180, f169, f173;
sub.f32 f181, f161, f165;
sub.f32 f182, f169, f173;
add.f32 f183, f175, f179;
add.f32 f184, f176, f180;
sub.f32 f185, f175, f179;
sub.f32 f186, f176, f180;
sub.f32 f187, f177, f182;
add.f32 f188, f178, f181;
add.f32 f189, f177, f182;
sub.f32 f190, f178, f181;
add.f32 f191, f160, f164;
add.f32 f192, f168, f172;
sub.f32 f193, f160, f164;
sub.f32 f194, f168, f172;
add.f32 f195, f162, f166;
add.f32 f196, f170, f174;
sub.f32 f197, f162, f166;
sub.f32 f198, f170, f174;
add.f32 f199, f191, f195;
add.f32 f200, f192, f196;
sub.f32 f201, f191, f195;
sub.f32 f202, f192, f196;
sub.f32 f203, f193, f198;
add.f32 f204, f194, f197;
add.f32 f205, f193, f198;
sub.f32 f206, f194, f197;
mul.f32 f207, f203, 0f3F3504F3;
mul.f32 f208, f204, 0f3F3504F3;
sub.f32 f209, f207, f208;
add.f32 f210, f207, f208;
mul.f32 f211, f205, 0fBF3504F3;
mul.f32 f212, f206, 0f3F3504F3;
sub.f32 f213, f211, f212;
mul.f32 f214, f206, 0fBF3504F3;
fma.rn.f32 f215, f205, 0f3F3504F3, f214;
add.f32 f216, f183, f199;
add.f32 f217, f184, f200;
sub.f32 f218, f183, f199;
sub.f32 f219, f184, f200;
add.f32 f220, f187, f209;
add.f32 f221, f188, f210;
sub.f32 f222, f187, f209;
sub.f32 f223, f188, f210;
sub.f32 f224, f185, f202;
add.f32 f225, f186, f201;
add.f32 f226, f185, f202;
sub.f32 f227, f186, f201;
add.f32 f228, f189, f213;
add.f32 f229, f190, f215;
sub.f32 f230, f189, f213;
sub.f32 f231, f190, f215;
and.b32 r14, r5, 8;
cvt.u64.u32 rd6, r14;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f232, f233}, [rd8];
mul.f32 f236, f221, f233;
fma.rn.f32 f237, f232, f220, f236;
mul.f32 f238, f220, f233;
mul.f32 f239, f232, f221;
sub.f32 f240, f239, f238;
mul.f32 f241, f232, f232;
mul.f32 f242, f233, f233;
sub.f32 f243, f241, f242;
mul.f32 f244, f233, f232;
fma.rn.f32 f245, f233, f232, f244;
mul.f32 f246, f225, f245;
fma.rn.f32 f247, f243, f224, f246;
mul.f32 f248, f224, f245;
mul.f32 f249, f243, f225;
sub.f32 f250, f249, f248;
mul.f32 f251, f232, f243;
mul.f32 f252, f233, f245;
sub.f32 f253, f251, f252;
mul.f32 f254, f232, f245;
fma.rn.f32 f255, f233, f243, f254;
mul.f32 f256, f229, f255;
fma.rn.f32 f257, f253, f228, f256;
mul.f32 f258, f228, f255;
mul.f32 f259, f253, f229;
sub.f32 f260, f259, f258;
mul.f32 f261, f232, f253;
mul.f32 f262, f233, f255;
sub.f32 f263, f261, f262;
mul.f32 f264, f232, f255;
fma.rn.f32 f265, f233, f253, f264;
mul.f32 f266, f219, f265;
fma.rn.f32 f267, f263, f218, f266;
mul.f32 f268, f218, f265;
mul.f32 f269, f263, f219;
sub.f32 f270, f269, f268;
mul.f32 f271, f232, f263;
mul.f32 f272, f233, f265;
sub.f32 f273, f271, f272;
mul.f32 f274, f232, f265;
fma.rn.f32 f275, f233, f263, f274;
mul.f32 f276, f223, f275;
fma.rn.f32 f277, f273, f222, f276;
mul.f32 f278, f222, f275;
mul.f32 f279, f273, f223;
sub.f32 f280, f279, f278;
mul.f32 f281, f232, f273;
mul.f32 f282, f233, f275;
sub.f32 f283, f281, f282;
mul.f32 f284, f232, f275;
fma.rn.f32 f285, f233, f273, f284;
mul.f32 f286, f227, f285;
fma.rn.f32 f287, f283, f226, f286;
mul.f32 f288, f226, f285;
mul.f32 f289, f283, f227;
sub.f32 f290, f289, f288;
mul.f32 f291, f232, f283;
mul.f32 f292, f233, f285;
sub.f32 f293, f291, f292;
mul.f32 f294, f232, f285;
fma.rn.f32 f295, f233, f283, f294;
mul.f32 f296, f231, f295;
fma.rn.f32 f297, f293, f230, f296;
mul.f32 f298, f230, f295;
mul.f32 f299, f293, f231;
sub.f32 f300, f299, f298;
shl.b32 r15, r5, 2;
and.b32 r16, r15, 28;
add.s32 r17, r10, r16;
barrier.sync 0;
and.b32 r18, r8, 256;
add.s32 r19, r17, r18;
st.shared.f32 [r19], f216;
st.shared.f32 [r19+32], f237;
st.shared.f32 [r19+64], f247;
st.shared.f32 [r19+96], f257;
st.shared.f32 [r19+128], f267;
st.shared.f32 [r19+160], f277;
st.shared.f32 [r19+192], f287;
st.shared.f32 [r19+224], f297;
barrier.sync 0;
mad.lo.s32 r20, r14, -28, r19;
ld.shared.f32 f301, [r20];
ld.shared.f32 f302, [r20+64];
ld.shared.f32 f303, [r20+128];
ld.shared.f32 f304, [r20+192];
ld.shared.f32 f305, [r20+256];
ld.shared.f32 f306, [r20+320];
ld.shared.f32 f307, [r20+384];
ld.shared.f32 f308, [r20+448];
barrier.sync 0;
st.shared.f32 [r19], f217;
st.shared.f32 [r19+32], f240;
st.shared.f32 [r19+64], f250;
st.shared.f32 [r19+96], f260;
st.shared.f32 [r19+128], f270;
st.shared.f32 [r19+160], f280;
st.shared.f32 [r19+192], f290;
st.shared.f32 [r19+224], f300;
barrier.sync 0;
ld.shared.f32 f309, [r20];
ld.shared.f32 f310, [r20+64];
ld.shared.f32 f311, [r20+128];
ld.shared.f32 f312, [r20+192];
ld.shared.f32 f313, [r20+256];
ld.shared.f32 f314, [r20+320];
ld.shared.f32 f315, [r20+384];
ld.shared.f32 f316, [r20+448];
add.f32 %0, f301, f305;
add.f32 %1, f309, f313;
add.f32 %2, f302, f306;
add.f32 %3, f310, f314;
add.f32 %4, f303, f307;
add.f32 %5, f311, f315;
add.f32 %6, f304, f308;
add.f32 %7, f312, f316;
sub.f32 %8, f301, f305;
sub.f32 %9, f309, f313;
sub.f32 %10, f302, f306;
sub.f32 %11, f310, f314;
sub.f32 %12, f303, f307;
sub.f32 %13, f311, f315;
sub.f32 %14, f304, f308;
sub.f32 %15, f312, f316;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y): "r"(smem), "l"(lut_sp_8_128), "l"(lut_sp_8_16), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<257, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<208>;
.reg .b32 r<28>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 10;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f17, %12, %17;
add.f32 f18, %13, %19;
sub.f32 f19, %12, %17;
sub.f32 f20, %13, %19;
add.f32 f21, %14, %20;
add.f32 f22, %16, %21;
sub.f32 f23, %14, %20;
sub.f32 f24, %16, %21;
sub.f32 f25, f17, f21;
sub.f32 f26, f18, f22;
sub.f32 f27, f19, f24;
add.f32 f28, f20, f23;
add.f32 f29, f19, f24;
sub.f32 f30, f20, f23;
and.b32 r6, r5, 31;
shl.b32 r7, r5, 5;
and.b32 r8, r7, -1024;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 248;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f31, f32}, [rd5];
mul.f32 f35, f28, f32;
mul.f32 f36, f27, f32;
mul.f32 f37, f31, f28;
mul.f32 f38, f31, f31;
mul.f32 f39, f32, f32;
sub.f32 f40, f38, f39;
mul.f32 f41, f32, f31;
fma.rn.f32 f42, f32, f31, f41;
mul.f32 f43, f26, f42;
mul.f32 f44, f25, f42;
mul.f32 f45, f40, f26;
mul.f32 f46, f31, f40;
mul.f32 f47, f32, f42;
sub.f32 f48, f46, f47;
mul.f32 f49, f31, f42;
fma.rn.f32 f50, f32, f40, f49;
mul.f32 f51, f30, f50;
mul.f32 f52, f29, f50;
mul.f32 f53, f48, f30;
barrier.sync 0;
and.b32 r11, r7, 992;
add.s32 r12, r9, r11;
add.f32 f54, f18, f22;
add.f32 f55, f17, f21;
fma.rn.f32 f56, f31, f27, f35;
sub.f32 f57, f37, f36;
st.shared.v4.f32 [r12], {f55, f54, f56, f57};
sub.f32 f58, f45, f44;
fma.rn.f32 f59, f40, f25, f43;
fma.rn.f32 f60, f48, f29, f51;
sub.f32 f61, f53, f52;
st.shared.v4.f32 [r12+16], {f59, f58, f60, f61};
barrier.sync 0;
mad.lo.s32 r13, r6, -24, r12;
ld.shared.v2.f32 {f62, f63}, [r13];
ld.shared.v2.f32 {f66, f67}, [r13+256];
ld.shared.v2.f32 {f70, f71}, [r13+512];
ld.shared.v2.f32 {f74, f75}, [r13+768];
add.f32 f78, f62, f70;
add.f32 f79, f63, f71;
sub.f32 f80, f62, f70;
sub.f32 f81, f63, f71;
add.f32 f82, f66, f74;
add.f32 f83, f67, f75;
sub.f32 f84, f66, f74;
sub.f32 f85, f67, f75;
sub.f32 f86, f78, f82;
sub.f32 f87, f79, f83;
sub.f32 f88, f80, f85;
add.f32 f89, f81, f84;
add.f32 f90, f80, f85;
sub.f32 f91, f81, f84;
and.b32 r14, r5, 28;
bfe.u32 r15, r5, 2, 3;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f92, f93}, [rd8];
mul.f32 f96, f89, f93;
mul.f32 f97, f88, f93;
mul.f32 f98, f92, f89;
mul.f32 f99, f92, f92;
mul.f32 f100, f93, f93;
sub.f32 f101, f99, f100;
mul.f32 f102, f93, f92;
fma.rn.f32 f103, f93, f92, f102;
mul.f32 f104, f87, f103;
mul.f32 f105, f86, f103;
mul.f32 f106, f101, f87;
mul.f32 f107, f92, f101;
mul.f32 f108, f93, f103;
sub.f32 f109, f107, f108;
mul.f32 f110, f92, f103;
fma.rn.f32 f111, f93, f101, f110;
mul.f32 f112, f91, f111;
mul.f32 f113, f90, f111;
mul.f32 f114, f109, f91;
and.b32 r16, r10, 24;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 896;
add.s32 r19, r17, r18;
add.f32 f115, f79, f83;
add.f32 f116, f78, f82;
st.shared.v2.f32 [r19], {f116, f115};
fma.rn.f32 f117, f92, f88, f96;
sub.f32 f118, f98, f97;
st.shared.v2.f32 [r19+32], {f117, f118};
fma.rn.f32 f119, f101, f86, f104;
sub.f32 f120, f106, f105;
st.shared.v2.f32 [r19+64], {f119, f120};
sub.f32 f121, f114, f113;
fma.rn.f32 f122, f109, f90, f112;
st.shared.v2.f32 [r19+96], {f122, f121};
barrier.sync 0;
mad.lo.s32 r20, r14, -24, r19;
ld.shared.v2.f32 {f123, f124}, [r20];
ld.shared.v2.f32 {f127, f128}, [r20+256];
ld.shared.v2.f32 {f131, f132}, [r20+512];
ld.shared.v2.f32 {f135, f136}, [r20+768];
add.f32 f139, f123, f131;
add.f32 f140, f124, f132;
sub.f32 f141, f123, f131;
sub.f32 f142, f124, f132;
add.f32 f143, f127, f135;
add.f32 f144, f128, f136;
sub.f32 f145, f127, f135;
sub.f32 f146, f128, f136;
sub.f32 f147, f139, f143;
sub.f32 f148, f140, f144;
sub.f32 f149, f141, f146;
add.f32 f150, f142, f145;
add.f32 f151, f141, f146;
sub.f32 f152, f142, f145;
and.b32 r21, r5, 16;
bfe.u32 r22, r5, 4, 1;
mul.wide.u32 rd9, r22, 8;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f153, f154}, [rd11];
mul.f32 f157, f150, f154;
mul.f32 f158, f149, f154;
mul.f32 f159, f153, f150;
mul.f32 f160, f153, f153;
mul.f32 f161, f154, f154;
sub.f32 f162, f160, f161;
mul.f32 f163, f154, f153;
fma.rn.f32 f164, f154, f153, f163;
mul.f32 f165, f148, f164;
mul.f32 f166, f147, f164;
mul.f32 f167, f162, f148;
mul.f32 f168, f153, f162;
mul.f32 f169, f154, f164;
sub.f32 f170, f168, f169;
mul.f32 f171, f153, f164;
fma.rn.f32 f172, f154, f162, f171;
mul.f32 f173, f152, f172;
mul.f32 f174, f151, f172;
mul.f32 f175, f170, f152;
and.b32 r23, r10, 120;
add.s32 r24, r9, r23;
barrier.sync 0;
and.b32 r25, r7, 512;
add.s32 r26, r24, r25;
add.f32 f176, f140, f144;
add.f32 f177, f139, f143;
st.shared.v2.f32 [r26], {f177, f176};
fma.rn.f32 f178, f153, f149, f157;
sub.f32 f179, f159, f158;
st.shared.v2.f32 [r26+128], {f178, f179};
fma.rn.f32 f180, f162, f147, f165;
sub.f32 f181, f167, f166;
st.shared.v2.f32 [r26+256], {f180, f181};
sub.f32 f182, f175, f174;
fma.rn.f32 f183, f170, f151, f173;
st.shared.v2.f32 [r26+384], {f183, f182};
barrier.sync 0;
mad.lo.s32 r27, r21, -24, r26;
ld.shared.v2.f32 {f184, f185}, [r27];
ld.shared.v2.f32 {f188, f189}, [r27+256];
ld.shared.v2.f32 {f192, f193}, [r27+512];
ld.shared.v2.f32 {f196, f197}, [r27+768];
add.f32 %1, f185, f193;
add.f32 %0, f184, f192;
add.f32 %3, f189, f197;
add.f32 %2, f188, f196;
sub.f32 %5, f185, f193;
sub.f32 %4, f184, f192;
sub.f32 %7, f189, f197;
sub.f32 %6, f188, f196;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y): "r"(smem), "l"(lut_sp_4_128), "l"(lut_sp_4_32), "l"(lut_sp_4_8), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<258, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<184>;
.reg .b32 r<29>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 9;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f17, %12, %17;
add.f32 f18, %13, %19;
sub.f32 f19, %12, %17;
sub.f32 f20, %13, %19;
add.f32 f21, %14, %20;
add.f32 f22, %16, %21;
sub.f32 f23, %14, %20;
sub.f32 f24, %16, %21;
add.f32 f25, f17, f21;
add.f32 f26, f18, f22;
sub.f32 f27, f17, f21;
sub.f32 f28, f18, f22;
sub.f32 f29, f19, f24;
add.f32 f30, f20, f23;
add.f32 f31, f19, f24;
sub.f32 f32, f20, f23;
and.b32 r6, r5, 31;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 248;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f33, f34}, [rd5];
mul.f32 f37, f30, f34;
fma.rn.f32 f38, f33, f29, f37;
mul.f32 f39, f29, f34;
mul.f32 f40, f33, f30;
sub.f32 f41, f40, f39;
mul.f32 f42, f33, f33;
mul.f32 f43, f34, f34;
sub.f32 f44, f42, f43;
mul.f32 f45, f34, f33;
fma.rn.f32 f46, f34, f33, f45;
mul.f32 f47, f28, f46;
fma.rn.f32 f48, f44, f27, f47;
mul.f32 f49, f27, f46;
mul.f32 f50, f44, f28;
sub.f32 f51, f50, f49;
mul.f32 f52, f33, f44;
mul.f32 f53, f34, f46;
sub.f32 f54, f52, f53;
mul.f32 f55, f33, f46;
fma.rn.f32 f56, f34, f44, f55;
mul.f32 f57, f32, f56;
fma.rn.f32 f58, f54, f31, f57;
mul.f32 f59, f31, f56;
mul.f32 f60, f54, f32;
sub.f32 f61, f60, f59;
shl.b32 r8, r5, 4;
and.b32 r9, r8, -512;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 496;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f25, f38, f48, f58};
barrier.sync 0;
mad.lo.s32 r13, r6, -12, r12;
ld.shared.f32 f62, [r13];
ld.shared.f32 f63, [r13+128];
ld.shared.f32 f64, [r13+256];
ld.shared.f32 f65, [r13+384];
barrier.sync 0;
st.shared.v4.f32 [r12], {f26, f41, f51, f61};
barrier.sync 0;
ld.shared.f32 f66, [r13];
ld.shared.f32 f67, [r13+128];
ld.shared.f32 f68, [r13+256];
ld.shared.f32 f69, [r13+384];
add.f32 f70, f62, f64;
add.f32 f71, f66, f68;
sub.f32 f72, f62, f64;
sub.f32 f73, f66, f68;
add.f32 f74, f63, f65;
add.f32 f75, f67, f69;
sub.f32 f76, f63, f65;
sub.f32 f77, f67, f69;
add.f32 f78, f70, f74;
add.f32 f79, f71, f75;
sub.f32 f80, f70, f74;
sub.f32 f81, f71, f75;
sub.f32 f82, f72, f77;
add.f32 f83, f73, f76;
add.f32 f84, f72, f77;
sub.f32 f85, f73, f76;
and.b32 r14, r5, 28;
bfe.u32 r15, r5, 2, 3;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f86, f87}, [rd8];
mul.f32 f90, f83, f87;
fma.rn.f32 f91, f86, f82, f90;
mul.f32 f92, f82, f87;
mul.f32 f93, f86, f83;
sub.f32 f94, f93, f92;
mul.f32 f95, f86, f86;
mul.f32 f96, f87, f87;
sub.f32 f97, f95, f96;
mul.f32 f98, f87, f86;
fma.rn.f32 f99, f87, f86, f98;
mul.f32 f100, f81, f99;
fma.rn.f32 f101, f97, f80, f100;
mul.f32 f102, f80, f99;
mul.f32 f103, f97, f81;
sub.f32 f104, f103, f102;
mul.f32 f105, f86, f97;
mul.f32 f106, f87, f99;
sub.f32 f107, f105, f106;
mul.f32 f108, f86, f99;
fma.rn.f32 f109, f87, f97, f108;
mul.f32 f110, f85, f109;
fma.rn.f32 f111, f107, f84, f110;
mul.f32 f112, f84, f109;
mul.f32 f113, f107, f85;
sub.f32 f114, f113, f112;
shl.b32 r16, r5, 2;
and.b32 r17, r16, 12;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 448;
add.s32 r20, r18, r19;
st.shared.f32 [r20], f78;
st.shared.f32 [r20+16], f91;
st.shared.f32 [r20+32], f101;
st.shared.f32 [r20+48], f111;
barrier.sync 0;
mad.lo.s32 r21, r14, -12, r20;
ld.shared.f32 f115, [r21];
ld.shared.f32 f116, [r21+128];
ld.shared.f32 f117, [r21+256];
ld.shared.f32 f118, [r21+384];
barrier.sync 0;
st.shared.f32 [r20], f79;
st.shared.f32 [r20+16], f94;
st.shared.f32 [r20+32], f104;
st.shared.f32 [r20+48], f114;
barrier.sync 0;
ld.shared.f32 f119, [r21];
ld.shared.f32 f120, [r21+128];
ld.shared.f32 f121, [r21+256];
ld.shared.f32 f122, [r21+384];
add.f32 f123, f115, f117;
add.f32 f124, f119, f121;
sub.f32 f125, f115, f117;
sub.f32 f126, f119, f121;
add.f32 f127, f116, f118;
add.f32 f128, f120, f122;
sub.f32 f129, f116, f118;
sub.f32 f130, f120, f122;
add.f32 f131, f123, f127;
add.f32 f132, f124, f128;
sub.f32 f133, f123, f127;
sub.f32 f134, f124, f128;
sub.f32 f135, f125, f130;
add.f32 f136, f126, f129;
add.f32 f137, f125, f130;
sub.f32 f138, f126, f129;
and.b32 r22, r5, 16;
bfe.u32 r23, r5, 4, 1;
mul.wide.u32 rd9, r23, 8;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f139, f140}, [rd11];
mul.f32 f143, f136, f140;
fma.rn.f32 f144, f139, f135, f143;
mul.f32 f145, f135, f140;
mul.f32 f146, f139, f136;
sub.f32 f147, f146, f145;
mul.f32 f148, f139, f139;
mul.f32 f149, f140, f140;
sub.f32 f150, f148, f149;
mul.f32 f151, f140, f139;
fma.rn.f32 f152, f140, f139, f151;
mul.f32 f153, f134, f152;
fma.rn.f32 f154, f150, f133, f153;
mul.f32 f155, f133, f152;
mul.f32 f156, f150, f134;
sub.f32 f157, f156, f155;
mul.f32 f158, f139, f150;
mul.f32 f159, f140, f152;
sub.f32 f160, f158, f159;
mul.f32 f161, f139, f152;
fma.rn.f32 f162, f140, f150, f161;
mul.f32 f163, f138, f162;
fma.rn.f32 f164, f160, f137, f163;
mul.f32 f165, f137, f162;
mul.f32 f166, f160, f138;
sub.f32 f167, f166, f165;
and.b32 r24, r16, 60;
add.s32 r25, r10, r24;
barrier.sync 0;
and.b32 r26, r8, 256;
add.s32 r27, r25, r26;
st.shared.f32 [r27], f131;
st.shared.f32 [r27+64], f144;
st.shared.f32 [r27+128], f154;
st.shared.f32 [r27+192], f164;
barrier.sync 0;
mad.lo.s32 r28, r22, -12, r27;
ld.shared.f32 f168, [r28];
ld.shared.f32 f169, [r28+128];
ld.shared.f32 f170, [r28+256];
ld.shared.f32 f171, [r28+384];
barrier.sync 0;
st.shared.f32 [r27], f132;
st.shared.f32 [r27+64], f147;
st.shared.f32 [r27+128], f157;
st.shared.f32 [r27+192], f167;
barrier.sync 0;
ld.shared.f32 f172, [r28];
ld.shared.f32 f173, [r28+128];
ld.shared.f32 f174, [r28+256];
ld.shared.f32 f175, [r28+384];
add.f32 %0, f168, f170;
add.f32 %1, f172, f174;
add.f32 %2, f169, f171;
add.f32 %3, f173, f175;
sub.f32 %4, f168, f170;
sub.f32 %5, f172, f174;
sub.f32 %6, f169, f171;
sub.f32 %7, f173, f175;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y): "r"(smem), "l"(lut_sp_4_128), "l"(lut_sp_4_32), "l"(lut_sp_4_8), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<259, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<1429>;
.reg .b32 r<20>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 10;
mov.u32 r3, %64;
add.s32 r4, r3, r2;
add.f32 f129, %66, %98;
sub.f32 f131, %66, %98;
add.f32 f1423, %67, %130;
sub.f32 f132, %67, %130;
add.f32 f133, %82, %114;
sub.f32 f135, %82, %114;
add.f32 f1421, %131, %115;
sub.f32 f136, %131, %115;
add.f32 f137, f129, f133;
sub.f32 f139, f129, f133;
add.f32 f1420, f1423, f1421;
sub.f32 f140, f1423, f1421;
sub.f32 f141, f131, f136;
add.f32 f143, f131, f136;
add.f32 f1419, f132, f135;
sub.f32 f144, f132, f135;
add.f32 f145, %74, %106;
sub.f32 f147, %74, %106;
add.f32 f1416, %133, %132;
sub.f32 f148, %133, %132;
add.f32 f149, %90, %122;
sub.f32 f151, %90, %122;
add.f32 f1414, %91, %134;
sub.f32 f152, %91, %134;
add.f32 f153, f145, f149;
sub.f32 f155, f145, f149;
add.f32 f1413, f1416, f1414;
sub.f32 f156, f1416, f1414;
sub.f32 f157, f147, f152;
add.f32 f159, f147, f152;
add.f32 f1412, f148, f151;
sub.f32 f160, f148, f151;
mul.f32 f161, f157, 0f3F3504F3;
mul.f32 f162, f1412, 0f3F3504F3;
sub.f32 f163, f161, f162;
add.f32 f164, f161, f162;
mul.f32 f1410, f159, 0fBF3504F3;
mul.f32 f1411, f160, 0f3F3504F3;
sub.f32 f167, f1410, f1411;
mul.f32 f168, f160, 0fBF3504F3;
fma.rn.f32 f169, f159, 0f3F3504F3, f168;
add.f32 f170, f137, f153;
sub.f32 f172, f137, f153;
add.f32 f1409, f1420, f1413;
sub.f32 f173, f1420, f1413;
add.f32 f174, f141, f163;
sub.f32 f176, f141, f163;
add.f32 f1408, f1419, f164;
sub.f32 f177, f1419, f164;
sub.f32 f178, f139, f156;
add.f32 f180, f139, f156;
add.f32 f1407, f140, f155;
sub.f32 f181, f140, f155;
add.f32 f182, f143, f167;
sub.f32 f184, f143, f167;
add.f32 f1406, f144, f169;
sub.f32 f185, f144, f169;
add.f32 f186, %70, %102;
sub.f32 f188, %70, %102;
add.f32 f1404, %135, %103;
sub.f32 f189, %135, %103;
add.f32 f190, %86, %118;
sub.f32 f192, %86, %118;
add.f32 f1401, %137, %136;
sub.f32 f193, %137, %136;
add.f32 f194, f186, f190;
sub.f32 f196, f186, f190;
add.f32 f1400, f1404, f1401;
sub.f32 f197, f1404, f1401;
sub.f32 f198, f188, f193;
add.f32 f200, f188, f193;
add.f32 f1399, f189, f192;
sub.f32 f201, f189, f192;
add.f32 f202, %78, %110;
sub.f32 f204, %78, %110;
add.f32 f1397, %79, %138;
sub.f32 f205, %79, %138;
add.f32 f206, %94, %126;
sub.f32 f208, %94, %126;
add.f32 f1395, %139, %127;
sub.f32 f209, %139, %127;
add.f32 f210, f202, f206;
sub.f32 f212, f202, f206;
add.f32 f1394, f1397, f1395;
sub.f32 f213, f1397, f1395;
sub.f32 f214, f204, f209;
add.f32 f216, f204, f209;
add.f32 f1393, f205, f208;
sub.f32 f217, f205, f208;
mul.f32 f218, f214, 0f3F3504F3;
mul.f32 f219, f1393, 0f3F3504F3;
sub.f32 f220, f218, f219;
add.f32 f221, f218, f219;
mul.f32 f1391, f216, 0fBF3504F3;
mul.f32 f1392, f217, 0f3F3504F3;
sub.f32 f224, f1391, f1392;
mul.f32 f225, f217, 0fBF3504F3;
fma.rn.f32 f226, f216, 0f3F3504F3, f225;
add.f32 f227, f194, f210;
sub.f32 f229, f194, f210;
add.f32 f1390, f1400, f1394;
sub.f32 f230, f1400, f1394;
add.f32 f231, f198, f220;
sub.f32 f233, f198, f220;
add.f32 f1389, f1399, f221;
sub.f32 f234, f1399, f221;
sub.f32 f235, f196, f213;
add.f32 f237, f196, f213;
add.f32 f1388, f197, f212;
sub.f32 f238, f197, f212;
add.f32 f239, f200, f224;
sub.f32 f241, f200, f224;
add.f32 f1387, f201, f226;
sub.f32 f242, f201, f226;
mul.f32 f1385, f231, 0f3F6C835E;
mul.f32 f1386, f1389, 0f3EC3EF15;
sub.f32 f245, f1385, f1386;
mul.f32 f246, f1389, 0f3F6C835E;
fma.rn.f32 f247, f231, 0f3EC3EF15, f246;
mul.f32 f248, f235, 0f3F3504F3;
mul.f32 f249, f1388, 0f3F3504F3;
sub.f32 f250, f248, f249;
add.f32 f251, f248, f249;
mul.f32 f253, f1387, 0f3F6C835E;
mul.f32 f1384, f239, 0f3EC3EF15;
sub.f32 f254, f1384, f253;
mul.f32 f255, f1387, 0f3EC3EF15;
fma.rn.f32 f256, f239, 0f3F6C835E, f255;
mul.f32 f258, f234, 0f3F6C835E;
mul.f32 f1383, f233, 0fBEC3EF15;
sub.f32 f259, f1383, f258;
mul.f32 f260, f234, 0fBEC3EF15;
fma.rn.f32 f261, f233, 0f3F6C835E, f260;
mul.f32 f1381, f237, 0fBF3504F3;
mul.f32 f1382, f238, 0f3F3504F3;
sub.f32 f264, f1381, f1382;
mul.f32 f265, f238, 0fBF3504F3;
fma.rn.f32 f266, f237, 0f3F3504F3, f265;
mul.f32 f1379, f241, 0fBF6C835E;
mul.f32 f1380, f242, 0f3EC3EF15;
sub.f32 f269, f1379, f1380;
mul.f32 f270, f242, 0fBF6C835E;
fma.rn.f32 f271, f241, 0f3EC3EF15, f270;
add.f32 f272, f170, f227;
sub.f32 f274, f170, f227;
add.f32 f1378, f1409, f1390;
sub.f32 f275, f1409, f1390;
add.f32 f276, f174, f245;
sub.f32 f278, f174, f245;
add.f32 f1377, f1408, f247;
sub.f32 f279, f1408, f247;
add.f32 f280, f178, f250;
sub.f32 f282, f178, f250;
add.f32 f1376, f1407, f251;
sub.f32 f283, f1407, f251;
add.f32 f284, f182, f254;
sub.f32 f286, f182, f254;
add.f32 f1375, f1406, f256;
sub.f32 f287, f1406, f256;
sub.f32 f288, f172, f230;
add.f32 f290, f172, f230;
add.f32 f1374, f173, f229;
sub.f32 f291, f173, f229;
add.f32 f292, f176, f259;
sub.f32 f294, f176, f259;
add.f32 f1373, f177, f261;
sub.f32 f295, f177, f261;
add.f32 f296, f180, f264;
sub.f32 f298, f180, f264;
add.f32 f1372, f181, f266;
sub.f32 f299, f181, f266;
add.f32 f300, f184, f269;
sub.f32 f302, f184, f269;
add.f32 f1371, f185, f271;
sub.f32 f303, f185, f271;
add.f32 f304, %68, %100;
sub.f32 f306, %68, %100;
add.f32 f1368, %141, %140;
sub.f32 f307, %141, %140;
add.f32 f308, %84, %116;
sub.f32 f310, %84, %116;
add.f32 f1366, %85, %142;
sub.f32 f311, %85, %142;
add.f32 f312, f304, f308;
sub.f32 f314, f304, f308;
add.f32 f1365, f1368, f1366;
sub.f32 f315, f1368, f1366;
sub.f32 f316, f306, f311;
add.f32 f318, f306, f311;
add.f32 f1364, f307, f310;
sub.f32 f319, f307, f310;
add.f32 f320, %76, %108;
sub.f32 f322, %76, %108;
add.f32 f1362, %143, %109;
sub.f32 f323, %143, %109;
add.f32 f324, %92, %124;
sub.f32 f326, %92, %124;
add.f32 f1359, %145, %144;
sub.f32 f327, %145, %144;
add.f32 f328, f320, f324;
sub.f32 f330, f320, f324;
add.f32 f1358, f1362, f1359;
sub.f32 f331, f1362, f1359;
sub.f32 f332, f322, f327;
add.f32 f334, f322, f327;
add.f32 f1357, f323, f326;
sub.f32 f335, f323, f326;
mul.f32 f336, f332, 0f3F3504F3;
mul.f32 f337, f1357, 0f3F3504F3;
sub.f32 f338, f336, f337;
add.f32 f339, f336, f337;
mul.f32 f341, f335, 0f3F3504F3;
mul.f32 f1356, f334, 0fBF3504F3;
sub.f32 f342, f1356, f341;
mul.f32 f343, f335, 0fBF3504F3;
fma.rn.f32 f344, f334, 0f3F3504F3, f343;
add.f32 f345, f312, f328;
sub.f32 f347, f312, f328;
add.f32 f1355, f1365, f1358;
sub.f32 f348, f1365, f1358;
add.f32 f349, f316, f338;
sub.f32 f351, f316, f338;
add.f32 f1354, f1364, f339;
sub.f32 f352, f1364, f339;
sub.f32 f353, f314, f331;
add.f32 f355, f314, f331;
add.f32 f1353, f315, f330;
sub.f32 f356, f315, f330;
add.f32 f357, f318, f342;
sub.f32 f359, f318, f342;
add.f32 f1352, f319, f344;
sub.f32 f360, f319, f344;
add.f32 f361, %72, %104;
sub.f32 f363, %72, %104;
add.f32 f1350, %73, %146;
sub.f32 f364, %73, %146;
add.f32 f365, %88, %120;
sub.f32 f367, %88, %120;
add.f32 f1348, %147, %121;
sub.f32 f368, %147, %121;
add.f32 f369, f361, f365;
sub.f32 f371, f361, f365;
add.f32 f1347, f1350, f1348;
sub.f32 f372, f1350, f1348;
sub.f32 f373, f363, f368;
add.f32 f375, f363, f368;
add.f32 f1346, f364, f367;
sub.f32 f376, f364, f367;
add.f32 f377, %80, %112;
sub.f32 f379, %80, %112;
add.f32 f1343, %149, %148;
sub.f32 f380, %149, %148;
add.f32 f381, %96, %128;
sub.f32 f383, %96, %128;
add.f32 f1342, %97, %129;
sub.f32 f384, %97, %129;
add.f32 f385, f377, f381;
sub.f32 f387, f377, f381;
add.f32 f1341, f1343, f1342;
sub.f32 f388, f1343, f1342;
sub.f32 f389, f379, f384;
add.f32 f391, f379, f384;
add.f32 f1340, f380, f383;
sub.f32 f392, f380, f383;
mul.f32 f393, f389, 0f3F3504F3;
mul.f32 f394, f1340, 0f3F3504F3;
sub.f32 f395, f393, f394;
add.f32 f396, f393, f394;
mul.f32 f1338, f391, 0fBF3504F3;
mul.f32 f1339, f392, 0f3F3504F3;
sub.f32 f399, f1338, f1339;
mul.f32 f400, f392, 0fBF3504F3;
fma.rn.f32 f401, f391, 0f3F3504F3, f400;
add.f32 f402, f369, f385;
sub.f32 f404, f369, f385;
add.f32 f1337, f1347, f1341;
sub.f32 f405, f1347, f1341;
add.f32 f406, f373, f395;
sub.f32 f408, f373, f395;
add.f32 f1336, f1346, f396;
sub.f32 f409, f1346, f396;
sub.f32 f410, f371, f388;
add.f32 f412, f371, f388;
add.f32 f1335, f372, f387;
sub.f32 f413, f372, f387;
add.f32 f414, f375, f399;
sub.f32 f416, f375, f399;
add.f32 f1334, f376, f401;
sub.f32 f417, f376, f401;
mul.f32 f419, f1336, 0f3EC3EF15;
mul.f32 f1333, f406, 0f3F6C835E;
sub.f32 f420, f1333, f419;
mul.f32 f421, f1336, 0f3F6C835E;
fma.rn.f32 f422, f406, 0f3EC3EF15, f421;
mul.f32 f423, f410, 0f3F3504F3;
mul.f32 f424, f1335, 0f3F3504F3;
sub.f32 f425, f423, f424;
add.f32 f426, f423, f424;
mul.f32 f428, f1334, 0f3F6C835E;
mul.f32 f1332, f414, 0f3EC3EF15;
sub.f32 f429, f1332, f428;
mul.f32 f430, f1334, 0f3EC3EF15;
fma.rn.f32 f431, f414, 0f3F6C835E, f430;
mul.f32 f433, f409, 0f3F6C835E;
mul.f32 f1331, f408, 0fBEC3EF15;
sub.f32 f434, f1331, f433;
mul.f32 f435, f409, 0fBEC3EF15;
fma.rn.f32 f436, f408, 0f3F6C835E, f435;
mul.f32 f438, f413, 0f3F3504F3;
mul.f32 f1330, f412, 0fBF3504F3;
sub.f32 f439, f1330, f438;
mul.f32 f440, f413, 0fBF3504F3;
fma.rn.f32 f441, f412, 0f3F3504F3, f440;
mul.f32 f443, f417, 0f3EC3EF15;
mul.f32 f1329, f416, 0fBF6C835E;
sub.f32 f444, f1329, f443;
mul.f32 f445, f417, 0fBF6C835E;
fma.rn.f32 f446, f416, 0f3EC3EF15, f445;
add.f32 f447, f345, f402;
sub.f32 f449, f345, f402;
add.f32 f1328, f1355, f1337;
sub.f32 f450, f1355, f1337;
add.f32 f451, f349, f420;
sub.f32 f453, f349, f420;
add.f32 f1327, f1354, f422;
sub.f32 f454, f1354, f422;
add.f32 f455, f353, f425;
sub.f32 f457, f353, f425;
add.f32 f1326, f1353, f426;
sub.f32 f458, f1353, f426;
add.f32 f459, f357, f429;
sub.f32 f461, f357, f429;
add.f32 f1325, f1352, f431;
sub.f32 f462, f1352, f431;
sub.f32 f463, f347, f405;
add.f32 f465, f347, f405;
add.f32 f1324, f348, f404;
sub.f32 f466, f348, f404;
add.f32 f467, f351, f434;
sub.f32 f469, f351, f434;
add.f32 f1323, f352, f436;
sub.f32 f470, f352, f436;
add.f32 f471, f355, f439;
sub.f32 f473, f355, f439;
add.f32 f1322, f356, f441;
sub.f32 f474, f356, f441;
add.f32 f475, f359, f444;
sub.f32 f477, f359, f444;
add.f32 f1321, f360, f446;
sub.f32 f478, f360, f446;
mul.f32 f480, f1327, 0f3E47C5C2;
mul.f32 f1320, f451, 0f3F7B14BE;
sub.f32 f481, f1320, f480;
mul.f32 f482, f1327, 0f3F7B14BE;
fma.rn.f32 f483, f451, 0f3E47C5C2, f482;
mul.f32 f485, f1326, 0f3EC3EF15;
mul.f32 f1319, f455, 0f3F6C835E;
sub.f32 f486, f1319, f485;
mul.f32 f487, f1326, 0f3F6C835E;
fma.rn.f32 f488, f455, 0f3EC3EF15, f487;
mul.f32 f490, f1325, 0f3F0E39DA;
mul.f32 f1318, f459, 0f3F54DB31;
sub.f32 f491, f1318, f490;
mul.f32 f492, f1325, 0f3F54DB31;
fma.rn.f32 f493, f459, 0f3F0E39DA, f492;
mul.f32 f494, f463, 0f3F3504F3;
mul.f32 f495, f1324, 0f3F3504F3;
sub.f32 f496, f494, f495;
add.f32 f497, f494, f495;
mul.f32 f499, f1323, 0f3F54DB31;
mul.f32 f1317, f467, 0f3F0E39DA;
sub.f32 f500, f1317, f499;
mul.f32 f501, f1323, 0f3F0E39DA;
fma.rn.f32 f502, f467, 0f3F54DB31, f501;
mul.f32 f504, f1322, 0f3F6C835E;
mul.f32 f1316, f471, 0f3EC3EF15;
sub.f32 f505, f1316, f504;
mul.f32 f506, f1322, 0f3EC3EF15;
fma.rn.f32 f507, f471, 0f3F6C835E, f506;
mul.f32 f509, f1321, 0f3F7B14BE;
mul.f32 f1315, f475, 0f3E47C5C2;
sub.f32 f510, f1315, f509;
mul.f32 f511, f1321, 0f3E47C5C2;
fma.rn.f32 f512, f475, 0f3F7B14BE, f511;
mul.f32 f514, f454, 0f3F7B14BE;
mul.f32 f1314, f453, 0fBE47C5C2;
sub.f32 f515, f1314, f514;
mul.f32 f516, f454, 0fBE47C5C2;
fma.rn.f32 f517, f453, 0f3F7B14BE, f516;
mul.f32 f1312, f457, 0fBEC3EF15;
mul.f32 f1313, f458, 0f3F6C835E;
sub.f32 f520, f1312, f1313;
mul.f32 f521, f458, 0fBEC3EF15;
fma.rn.f32 f522, f457, 0f3F6C835E, f521;
mul.f32 f1310, f461, 0fBF0E39DA;
mul.f32 f1311, f462, 0f3F54DB31;
sub.f32 f525, f1310, f1311;
mul.f32 f526, f462, 0fBF0E39DA;
fma.rn.f32 f527, f461, 0f3F54DB31, f526;
mul.f32 f1308, f465, 0fBF3504F3;
mul.f32 f1309, f466, 0f3F3504F3;
sub.f32 f530, f1308, f1309;
mul.f32 f531, f466, 0fBF3504F3;
fma.rn.f32 f532, f465, 0f3F3504F3, f531;
mul.f32 f1306, f469, 0fBF54DB31;
mul.f32 f1307, f470, 0f3F0E39DA;
sub.f32 f535, f1306, f1307;
mul.f32 f536, f470, 0fBF54DB31;
fma.rn.f32 f537, f469, 0f3F0E39DA, f536;
mul.f32 f539, f474, 0f3EC3EF15;
mul.f32 f1305, f473, 0fBF6C835E;
sub.f32 f540, f1305, f539;
mul.f32 f541, f474, 0fBF6C835E;
fma.rn.f32 f542, f473, 0f3EC3EF15, f541;
mul.f32 f544, f478, 0f3E47C5C2;
mul.f32 f1304, f477, 0fBF7B14BE;
sub.f32 f545, f1304, f544;
mul.f32 f546, f478, 0fBF7B14BE;
fma.rn.f32 f547, f477, 0f3E47C5C2, f546;
add.f32 f550, f276, f481;
sub.f32 f552, f276, f481;
add.f32 f1303, f1377, f483;
sub.f32 f553, f1377, f483;
add.f32 f554, f280, f486;
sub.f32 f556, f280, f486;
add.f32 f1302, f1376, f488;
sub.f32 f557, f1376, f488;
add.f32 f558, f284, f491;
sub.f32 f560, f284, f491;
add.f32 f1301, f1375, f493;
sub.f32 f561, f1375, f493;
add.f32 f562, f288, f496;
sub.f32 f564, f288, f496;
add.f32 f1300, f1374, f497;
sub.f32 f565, f1374, f497;
add.f32 f566, f292, f500;
sub.f32 f568, f292, f500;
add.f32 f1299, f1373, f502;
sub.f32 f569, f1373, f502;
add.f32 f570, f296, f505;
sub.f32 f572, f296, f505;
add.f32 f1298, f1372, f507;
sub.f32 f573, f1372, f507;
add.f32 f574, f300, f510;
sub.f32 f576, f300, f510;
add.f32 f1297, f1371, f512;
sub.f32 f577, f1371, f512;
sub.f32 f578, f274, f450;
add.f32 f580, f274, f450;
add.f32 f1296, f275, f449;
sub.f32 f581, f275, f449;
add.f32 f582, f278, f515;
sub.f32 f584, f278, f515;
add.f32 f1295, f279, f517;
sub.f32 f585, f279, f517;
add.f32 f586, f282, f520;
sub.f32 f588, f282, f520;
add.f32 f1294, f283, f522;
sub.f32 f589, f283, f522;
add.f32 f590, f286, f525;
sub.f32 f592, f286, f525;
add.f32 f1293, f287, f527;
sub.f32 f593, f287, f527;
add.f32 f594, f290, f530;
sub.f32 f596, f290, f530;
add.f32 f1292, f291, f532;
sub.f32 f597, f291, f532;
add.f32 f598, f294, f535;
sub.f32 f600, f294, f535;
add.f32 f1291, f295, f537;
sub.f32 f601, f295, f537;
add.f32 f602, f298, f540;
sub.f32 f604, f298, f540;
add.f32 f1290, f299, f542;
sub.f32 f605, f299, f542;
add.f32 f606, f302, f545;
sub.f32 f608, f302, f545;
add.f32 f1289, f303, f547;
sub.f32 f609, f303, f547;
mov.u32 r15, %tid.x;
shl.b32 r7, r15, 8;
and.b32 r8, r7, -1024;
add.s32 r9, r4, r8;
and.b32 r14, r15, 3;
shl.b32 r10, r15, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 24;
mov.u64 rd4, %65;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f610, f611}, [rd5];
mul.f32 f614, f1303, f611;
mul.f32 f616, f610, f1303;
mul.f32 f618, f611, f611;
mul.f32 f1288, f610, f610;
sub.f32 f619, f1288, f618;
mul.f32 f620, f611, f610;
fma.rn.f32 f621, f611, f610, f620;
mul.f32 f622, f1302, f621;
mul.f32 f624, f619, f1302;
mul.f32 f626, f611, f621;
mul.f32 f1287, f610, f619;
sub.f32 f627, f1287, f626;
mul.f32 f1286, f554, f621;
mul.f32 f628, f610, f621;
fma.rn.f32 f629, f611, f619, f628;
mul.f32 f630, f1301, f629;
mul.f32 f632, f627, f1301;
mul.f32 f1284, f610, f627;
mul.f32 f1285, f611, f629;
sub.f32 f635, f1284, f1285;
mul.f32 f1283, f558, f629;
mul.f32 f636, f610, f629;
fma.rn.f32 f637, f611, f627, f636;
mul.f32 f638, f1300, f637;
mul.f32 f640, f635, f1300;
mul.f32 f642, f611, f637;
mul.f32 f1282, f610, f635;
sub.f32 f643, f1282, f642;
mul.f32 f1281, f562, f637;
mul.f32 f644, f610, f637;
fma.rn.f32 f645, f611, f635, f644;
mul.f32 f646, f1299, f645;
mul.f32 f648, f643, f1299;
mul.f32 f1279, f610, f643;
mul.f32 f1280, f611, f645;
sub.f32 f651, f1279, f1280;
mul.f32 f1278, f566, f645;
mul.f32 f652, f610, f645;
fma.rn.f32 f653, f611, f643, f652;
mul.f32 f654, f1298, f653;
mul.f32 f656, f651, f1298;
mul.f32 f658, f611, f653;
mul.f32 f1277, f610, f651;
sub.f32 f659, f1277, f658;
mul.f32 f1276, f570, f653;
mul.f32 f660, f610, f653;
fma.rn.f32 f661, f611, f651, f660;
mul.f32 f662, f1297, f661;
mul.f32 f664, f659, f1297;
mul.f32 f666, f611, f661;
mul.f32 f1275, f610, f659;
sub.f32 f667, f1275, f666;
mul.f32 f1274, f574, f661;
mul.f32 f668, f610, f661;
fma.rn.f32 f669, f611, f659, f668;
mul.f32 f670, f1296, f669;
mul.f32 f672, f667, f1296;
mul.f32 f1272, f610, f667;
mul.f32 f1273, f611, f669;
sub.f32 f675, f1272, f1273;
mul.f32 f1271, f578, f669;
mul.f32 f676, f610, f669;
fma.rn.f32 f677, f611, f667, f676;
mul.f32 f678, f1295, f677;
mul.f32 f680, f675, f1295;
mul.f32 f682, f611, f677;
mul.f32 f1270, f610, f675;
sub.f32 f683, f1270, f682;
mul.f32 f1269, f582, f677;
mul.f32 f684, f610, f677;
fma.rn.f32 f685, f611, f675, f684;
mul.f32 f686, f1294, f685;
mul.f32 f688, f683, f1294;
mul.f32 f690, f611, f685;
mul.f32 f1268, f610, f683;
sub.f32 f691, f1268, f690;
mul.f32 f1267, f586, f685;
mul.f32 f692, f610, f685;
fma.rn.f32 f693, f611, f683, f692;
mul.f32 f694, f1293, f693;
mul.f32 f696, f691, f1293;
mul.f32 f1265, f610, f691;
mul.f32 f1266, f611, f693;
sub.f32 f699, f1265, f1266;
mul.f32 f1264, f590, f693;
mul.f32 f700, f610, f693;
fma.rn.f32 f701, f611, f691, f700;
mul.f32 f702, f1292, f701;
mul.f32 f704, f699, f1292;
mul.f32 f706, f611, f701;
mul.f32 f1263, f610, f699;
sub.f32 f707, f1263, f706;
mul.f32 f1262, f594, f701;
mul.f32 f708, f610, f701;
fma.rn.f32 f709, f611, f699, f708;
mul.f32 f710, f1291, f709;
mul.f32 f712, f707, f1291;
mul.f32 f1260, f610, f707;
mul.f32 f1261, f611, f709;
sub.f32 f715, f1260, f1261;
mul.f32 f1259, f598, f709;
mul.f32 f716, f610, f709;
fma.rn.f32 f717, f611, f707, f716;
mul.f32 f718, f1290, f717;
mul.f32 f720, f715, f1290;
mul.f32 f722, f611, f717;
mul.f32 f1258, f610, f715;
sub.f32 f723, f1258, f722;
mul.f32 f1257, f602, f717;
mul.f32 f724, f610, f717;
fma.rn.f32 f725, f611, f715, f724;
mul.f32 f726, f1289, f725;
mul.f32 f728, f723, f1289;
mul.f32 f730, f611, f725;
mul.f32 f1256, f610, f723;
sub.f32 f731, f1256, f730;
mul.f32 f1255, f606, f725;
mul.f32 f732, f610, f725;
fma.rn.f32 f733, f611, f723, f732;
sub.f32 f1254, f1378, f1328;
mul.f32 f734, f1254, f733;
mul.f32 f736, f731, f1254;
mul.f32 f1252, f610, f731;
mul.f32 f1253, f611, f733;
sub.f32 f739, f1252, f1253;
sub.f32 f1251, f272, f447;
mul.f32 f1250, f1251, f733;
mul.f32 f740, f610, f733;
fma.rn.f32 f741, f611, f731, f740;
mul.f32 f742, f553, f741;
mul.f32 f744, f739, f553;
mul.f32 f746, f611, f741;
mul.f32 f1249, f610, f739;
sub.f32 f747, f1249, f746;
mul.f32 f1248, f552, f741;
mul.f32 f748, f610, f741;
fma.rn.f32 f749, f611, f739, f748;
mul.f32 f750, f557, f749;
mul.f32 f752, f747, f557;
mul.f32 f754, f611, f749;
mul.f32 f1247, f610, f747;
sub.f32 f755, f1247, f754;
mul.f32 f1246, f556, f749;
mul.f32 f756, f610, f749;
fma.rn.f32 f757, f611, f747, f756;
mul.f32 f758, f561, f757;
mul.f32 f760, f755, f561;
mul.f32 f1244, f610, f755;
mul.f32 f1245, f611, f757;
sub.f32 f763, f1244, f1245;
mul.f32 f1243, f560, f757;
mul.f32 f764, f610, f757;
fma.rn.f32 f765, f611, f755, f764;
mul.f32 f766, f565, f765;
mul.f32 f768, f763, f565;
mul.f32 f770, f611, f765;
mul.f32 f1242, f610, f763;
sub.f32 f771, f1242, f770;
mul.f32 f1241, f564, f765;
mul.f32 f772, f610, f765;
fma.rn.f32 f773, f611, f763, f772;
mul.f32 f774, f569, f773;
mul.f32 f776, f771, f569;
mul.f32 f1239, f610, f771;
mul.f32 f1240, f611, f773;
sub.f32 f779, f1239, f1240;
mul.f32 f1238, f568, f773;
mul.f32 f780, f610, f773;
fma.rn.f32 f781, f611, f771, f780;
mul.f32 f782, f573, f781;
mul.f32 f784, f779, f573;
mul.f32 f786, f611, f781;
mul.f32 f1237, f610, f779;
sub.f32 f787, f1237, f786;
mul.f32 f1236, f572, f781;
mul.f32 f788, f610, f781;
fma.rn.f32 f789, f611, f779, f788;
mul.f32 f790, f577, f789;
mul.f32 f792, f787, f577;
mul.f32 f794, f611, f789;
mul.f32 f1235, f610, f787;
sub.f32 f795, f1235, f794;
mul.f32 f1234, f576, f789;
mul.f32 f796, f610, f789;
fma.rn.f32 f797, f611, f787, f796;
mul.f32 f798, f581, f797;
mul.f32 f800, f795, f581;
mul.f32 f1232, f610, f795;
mul.f32 f1233, f611, f797;
sub.f32 f803, f1232, f1233;
mul.f32 f1231, f580, f797;
mul.f32 f804, f610, f797;
fma.rn.f32 f805, f611, f795, f804;
mul.f32 f806, f585, f805;
mul.f32 f808, f803, f585;
mul.f32 f810, f611, f805;
mul.f32 f1230, f610, f803;
sub.f32 f811, f1230, f810;
mul.f32 f1229, f584, f805;
mul.f32 f812, f610, f805;
fma.rn.f32 f813, f611, f803, f812;
mul.f32 f814, f589, f813;
mul.f32 f816, f811, f589;
mul.f32 f818, f611, f813;
mul.f32 f1228, f610, f811;
sub.f32 f819, f1228, f818;
mul.f32 f1227, f588, f813;
mul.f32 f820, f610, f813;
fma.rn.f32 f821, f611, f811, f820;
mul.f32 f822, f593, f821;
mul.f32 f824, f819, f593;
mul.f32 f1225, f610, f819;
mul.f32 f1226, f611, f821;
sub.f32 f827, f1225, f1226;
mul.f32 f1224, f592, f821;
mul.f32 f828, f610, f821;
fma.rn.f32 f829, f611, f819, f828;
mul.f32 f830, f597, f829;
mul.f32 f832, f827, f597;
mul.f32 f834, f611, f829;
mul.f32 f1223, f610, f827;
sub.f32 f835, f1223, f834;
mul.f32 f1222, f596, f829;
mul.f32 f836, f610, f829;
fma.rn.f32 f837, f611, f827, f836;
mul.f32 f838, f601, f837;
mul.f32 f840, f835, f601;
mul.f32 f1220, f610, f835;
mul.f32 f1221, f611, f837;
sub.f32 f843, f1220, f1221;
mul.f32 f1219, f600, f837;
mul.f32 f844, f610, f837;
fma.rn.f32 f845, f611, f835, f844;
mul.f32 f846, f605, f845;
mul.f32 f848, f843, f605;
mul.f32 f850, f611, f845;
mul.f32 f1218, f610, f843;
sub.f32 f851, f1218, f850;
mul.f32 f1217, f604, f845;
mul.f32 f852, f610, f845;
mul.f32 f1216, f550, f611;
fma.rn.f32 f853, f611, f843, f852;
mul.f32 f854, f609, f853;
mul.f32 f855, f608, f853;
mul.f32 f856, f851, f609;
barrier.sync 0;
and.b32 r11, r7, 768;
add.s32 r12, r9, r11;
sub.f32 f1428, f1378, f1328;
mul.f32 f1427, f731, f1428;
add.f32 f857, f1378, f1328;
sub.f32 f1426, f272, f447;
add.f32 f858, f272, f447;
mov.u32 r17, %tid.x;
and.b32 r16, r17, 3;
mov.u32 r19, %tid.x;
and.b32 r18, r19, 3;
fma.rn.f32 f859, f610, f550, f614;
sub.f32 f860, f616, f1216;
st.shared.v4.f32 [r12], {f858, f857, f859, f860};
fma.rn.f32 f861, f619, f554, f622;
sub.f32 f862, f624, f1286;
fma.rn.f32 f863, f627, f558, f630;
sub.f32 f864, f632, f1283;
st.shared.v4.f32 [r12+16], {f861, f862, f863, f864};
fma.rn.f32 f865, f635, f562, f638;
sub.f32 f866, f640, f1281;
sub.f32 f867, f648, f1278;
fma.rn.f32 f868, f643, f566, f646;
st.shared.v4.f32 [r12+32], {f865, f866, f868, f867};
fma.rn.f32 f869, f651, f570, f654;
sub.f32 f870, f656, f1276;
fma.rn.f32 f871, f659, f574, f662;
sub.f32 f872, f664, f1274;
st.shared.v4.f32 [r12+48], {f869, f870, f871, f872};
fma.rn.f32 f873, f667, f578, f670;
sub.f32 f874, f672, f1271;
fma.rn.f32 f875, f675, f582, f678;
sub.f32 f876, f680, f1269;
st.shared.v4.f32 [r12+64], {f873, f874, f875, f876};
fma.rn.f32 f877, f683, f586, f686;
sub.f32 f878, f688, f1267;
fma.rn.f32 f879, f691, f590, f694;
sub.f32 f880, f696, f1264;
st.shared.v4.f32 [r12+80], {f877, f878, f879, f880};
fma.rn.f32 f881, f699, f594, f702;
sub.f32 f882, f704, f1262;
fma.rn.f32 f883, f707, f598, f710;
sub.f32 f884, f712, f1259;
st.shared.v4.f32 [r12+96], {f881, f882, f883, f884};
fma.rn.f32 f885, f715, f602, f718;
sub.f32 f886, f720, f1257;
fma.rn.f32 f887, f723, f606, f726;
sub.f32 f888, f728, f1255;
st.shared.v4.f32 [r12+112], {f885, f886, f887, f888};
fma.rn.f32 f889, f731, f1426, f734;
sub.f32 f890, f1427, f1250;
fma.rn.f32 f891, f739, f552, f742;
sub.f32 f892, f744, f1248;
st.shared.v4.f32 [r12+128], {f889, f890, f891, f892};
fma.rn.f32 f893, f747, f556, f750;
sub.f32 f894, f752, f1246;
fma.rn.f32 f895, f755, f560, f758;
sub.f32 f896, f760, f1243;
st.shared.v4.f32 [r12+144], {f893, f894, f895, f896};
fma.rn.f32 f897, f763, f564, f766;
sub.f32 f898, f768, f1241;
fma.rn.f32 f899, f771, f568, f774;
sub.f32 f900, f776, f1238;
st.shared.v4.f32 [r12+160], {f897, f898, f899, f900};
fma.rn.f32 f901, f779, f572, f782;
sub.f32 f902, f784, f1236;
fma.rn.f32 f903, f787, f576, f790;
sub.f32 f904, f792, f1234;
st.shared.v4.f32 [r12+176], {f901, f902, f903, f904};
fma.rn.f32 f905, f795, f580, f798;
sub.f32 f906, f800, f1231;
fma.rn.f32 f907, f803, f584, f806;
sub.f32 f908, f808, f1229;
st.shared.v4.f32 [r12+192], {f905, f906, f907, f908};
fma.rn.f32 f909, f811, f588, f814;
sub.f32 f910, f816, f1227;
fma.rn.f32 f911, f819, f592, f822;
sub.f32 f912, f824, f1224;
st.shared.v4.f32 [r12+208], {f909, f910, f911, f912};
fma.rn.f32 f913, f827, f596, f830;
sub.f32 f914, f832, f1222;
fma.rn.f32 f915, f835, f600, f838;
sub.f32 f916, f840, f1219;
st.shared.v4.f32 [r12+224], {f913, f914, f915, f916};
fma.rn.f32 f917, f843, f604, f846;
sub.f32 f918, f848, f1217;
fma.rn.f32 f919, f851, f608, f854;
sub.f32 f920, f856, f855;
st.shared.v4.f32 [r12+240], {f917, f918, f919, f920};
barrier.sync 0;
mad.lo.s32 r13, r18, -248, r12;
ld.shared.v2.f32 {f921, f922}, [r13];
ld.shared.v2.f32 {f925, f926}, [r13+32];
ld.shared.v2.f32 {f929, f930}, [r13+64];
ld.shared.v2.f32 {f933, f934}, [r13+96];
ld.shared.v2.f32 {f937, f938}, [r13+128];
ld.shared.v2.f32 {f941, f942}, [r13+160];
ld.shared.v2.f32 {f945, f946}, [r13+192];
ld.shared.v2.f32 {f949, f950}, [r13+224];
ld.shared.v2.f32 {f953, f954}, [r13+256];
ld.shared.v2.f32 {f957, f958}, [r13+288];
ld.shared.v2.f32 {f961, f962}, [r13+320];
ld.shared.v2.f32 {f965, f966}, [r13+352];
ld.shared.v2.f32 {f969, f970}, [r13+384];
ld.shared.v2.f32 {f973, f974}, [r13+416];
ld.shared.v2.f32 {f977, f978}, [r13+448];
ld.shared.v2.f32 {f981, f982}, [r13+480];
ld.shared.v2.f32 {f985, f986}, [r13+512];
ld.shared.v2.f32 {f989, f990}, [r13+544];
ld.shared.v2.f32 {f993, f994}, [r13+576];
ld.shared.v2.f32 {f997, f998}, [r13+608];
ld.shared.v2.f32 {f1001, f1002}, [r13+640];
ld.shared.v2.f32 {f1005, f1006}, [r13+672];
ld.shared.v2.f32 {f1009, f1010}, [r13+704];
ld.shared.v2.f32 {f1013, f1014}, [r13+736];
ld.shared.v2.f32 {f1017, f1018}, [r13+768];
ld.shared.v2.f32 {f1021, f1022}, [r13+800];
ld.shared.v2.f32 {f1025, f1026}, [r13+832];
ld.shared.v2.f32 {f1029, f1030}, [r13+864];
ld.shared.v2.f32 {f1033, f1034}, [r13+896];
ld.shared.v2.f32 {f1037, f1038}, [r13+928];
ld.shared.v2.f32 {f1041, f1042}, [r13+960];
ld.shared.v2.f32 {f1045, f1046}, [r13+992];
add.f32 f1049, f921, f985;
sub.f32 f1051, f921, f985;
add.f32 f1215, f922, f986;
sub.f32 f1052, f922, f986;
add.f32 f1053, f953, f1017;
sub.f32 f1055, f953, f1017;
add.f32 f1214, f954, f1018;
sub.f32 f1056, f954, f1018;
add.f32 f1057, f925, f989;
sub.f32 f1059, f925, f989;
add.f32 f1213, f926, f990;
sub.f32 f1060, f926, f990;
add.f32 f1061, f957, f1021;
sub.f32 f1063, f957, f1021;
add.f32 f1212, f958, f1022;
sub.f32 f1064, f958, f1022;
add.f32 f1065, f929, f993;
sub.f32 f1067, f929, f993;
add.f32 f1211, f930, f994;
sub.f32 f1068, f930, f994;
add.f32 f1069, f961, f1025;
sub.f32 f1071, f961, f1025;
add.f32 f1210, f962, f1026;
sub.f32 f1072, f962, f1026;
add.f32 f1073, f933, f997;
sub.f32 f1075, f933, f997;
add.f32 f1209, f934, f998;
sub.f32 f1076, f934, f998;
add.f32 f1077, f965, f1029;
sub.f32 f1079, f965, f1029;
add.f32 f1208, f966, f1030;
sub.f32 f1080, f966, f1030;
add.f32 f1081, f937, f1001;
sub.f32 f1083, f937, f1001;
add.f32 f1207, f938, f1002;
sub.f32 f1084, f938, f1002;
add.f32 f1085, f969, f1033;
sub.f32 f1087, f969, f1033;
add.f32 f1206, f970, f1034;
sub.f32 f1088, f970, f1034;
add.f32 f1089, f941, f1005;
sub.f32 f1091, f941, f1005;
add.f32 f1205, f942, f1006;
sub.f32 f1092, f942, f1006;
add.f32 f1093, f973, f1037;
sub.f32 f1095, f973, f1037;
add.f32 f1204, f974, f1038;
sub.f32 f1096, f974, f1038;
add.f32 f1097, f945, f1009;
sub.f32 f1099, f945, f1009;
add.f32 f1203, f946, f1010;
sub.f32 f1100, f946, f1010;
add.f32 f1101, f977, f1041;
sub.f32 f1103, f977, f1041;
add.f32 f1202, f978, f1042;
sub.f32 f1104, f978, f1042;
add.f32 f1105, f949, f1013;
sub.f32 f1107, f949, f1013;
add.f32 f1201, f950, f1014;
sub.f32 f1108, f950, f1014;
add.f32 f1109, f981, f1045;
sub.f32 f1111, f981, f1045;
add.f32 f1200, f982, f1046;
sub.f32 f1112, f982, f1046;
add.f32 %1, f1215, f1214;
add.f32 %0, f1049, f1053;
add.f32 %2, f1057, f1061;
add.f32 %3, f1213, f1212;
add.f32 %4, f1065, f1069;
add.f32 %5, f1211, f1210;
add.f32 %6, f1073, f1077;
add.f32 %7, f1209, f1208;
add.f32 %8, f1081, f1085;
add.f32 %9, f1207, f1206;
add.f32 %11, f1205, f1204;
add.f32 %10, f1089, f1093;
add.f32 %13, f1203, f1202;
add.f32 %12, f1097, f1101;
add.f32 %15, f1201, f1200;
add.f32 %14, f1105, f1109;
sub.f32 %16, f1051, f1056;
add.f32 %17, f1052, f1055;
sub.f32 %18, f1059, f1064;
add.f32 %19, f1060, f1063;
sub.f32 %20, f1067, f1072;
add.f32 %21, f1068, f1071;
add.f32 %23, f1076, f1079;
sub.f32 %22, f1075, f1080;
add.f32 %25, f1084, f1087;
sub.f32 %24, f1083, f1088;
add.f32 %27, f1092, f1095;
sub.f32 %26, f1091, f1096;
sub.f32 %28, f1099, f1104;
add.f32 %29, f1100, f1103;
sub.f32 %30, f1107, f1112;
add.f32 %31, f1108, f1111;
sub.f32 %33, f1215, f1214;
sub.f32 %32, f1049, f1053;
sub.f32 %35, f1213, f1212;
sub.f32 %34, f1057, f1061;
sub.f32 %37, f1211, f1210;
sub.f32 %36, f1065, f1069;
sub.f32 %39, f1209, f1208;
sub.f32 %38, f1073, f1077;
sub.f32 %41, f1207, f1206;
sub.f32 %40, f1081, f1085;
sub.f32 %43, f1205, f1204;
sub.f32 %42, f1089, f1093;
sub.f32 %45, f1203, f1202;
sub.f32 %44, f1097, f1101;
sub.f32 %47, f1201, f1200;
sub.f32 %46, f1105, f1109;
sub.f32 %49, f1052, f1055;
add.f32 %48, f1051, f1056;
sub.f32 %51, f1060, f1063;
add.f32 %50, f1059, f1064;
sub.f32 %53, f1068, f1071;
add.f32 %52, f1067, f1072;
sub.f32 %55, f1076, f1079;
add.f32 %54, f1075, f1080;
sub.f32 %57, f1084, f1087;
add.f32 %56, f1083, f1088;
sub.f32 %59, f1092, f1095;
add.f32 %58, f1091, f1096;
sub.f32 %61, f1100, f1103;
add.f32 %60, f1099, f1104;
sub.f32 %63, f1108, f1111;
add.f32 %62, f1107, f1112;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y), "=f"(rmem[27].x), "=f"(rmem[27].y), "=f"(rmem[28].x), "=f"(rmem[28].y), "=f"(rmem[29].x), "=f"(rmem[29].y), "=f"(rmem[30].x), "=f"(rmem[30].y), "=f"(rmem[31].x), "=f"(rmem[31].y): "r"(smem), "l"(lut_sp_32_128), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[27].x), "f"(rmem[27].y), "f"(rmem[28].x), "f"(rmem[28].y), "f"(rmem[29].x), "f"(rmem[29].y), "f"(rmem[30].x), "f"(rmem[30].y), "f"(rmem[31].x), "f"(rmem[31].y), "f"(rmem[16].y), "f"(rmem[8].y), "f"(rmem[20].y), "f"(rmem[4].y), "f"(rmem[28].y), "f"(rmem[2].y), "f"(rmem[26].y), "f"(rmem[10].y), "f"(rmem[22].y), "f"(rmem[14].y), "f"(rmem[17].y), "f"(rmem[1].y), "f"(rmem[25].y), "f"(rmem[5].y), "f"(rmem[29].y), "f"(rmem[13].y), "f"(rmem[19].y), "f"(rmem[11].y), "f"(rmem[23].y), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<260, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<1333>;
.reg .b32 r<18>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 9;
mov.u32 r3, %64;
add.s32 r4, r3, r2;
add.f32 f129, %66, %98;
sub.f32 f131, %66, %98;
add.f32 f1331, %67, %130;
sub.f32 f132, %67, %130;
add.f32 f133, %82, %114;
sub.f32 f135, %82, %114;
add.f32 f1329, %131, %115;
sub.f32 f136, %131, %115;
add.f32 f137, f129, f133;
sub.f32 f139, f129, f133;
add.f32 f1328, f1331, f1329;
sub.f32 f140, f1331, f1329;
sub.f32 f141, f131, f136;
add.f32 f143, f131, f136;
add.f32 f1327, f132, f135;
sub.f32 f144, f132, f135;
add.f32 f145, %74, %106;
sub.f32 f147, %74, %106;
add.f32 f1324, %133, %132;
sub.f32 f148, %133, %132;
add.f32 f149, %90, %122;
sub.f32 f151, %90, %122;
add.f32 f1322, %91, %134;
sub.f32 f152, %91, %134;
add.f32 f153, f145, f149;
sub.f32 f155, f145, f149;
add.f32 f1321, f1324, f1322;
sub.f32 f156, f1324, f1322;
sub.f32 f157, f147, f152;
add.f32 f159, f147, f152;
add.f32 f1320, f148, f151;
sub.f32 f160, f148, f151;
mul.f32 f161, f157, 0f3F3504F3;
mul.f32 f162, f1320, 0f3F3504F3;
sub.f32 f163, f161, f162;
add.f32 f164, f161, f162;
mul.f32 f1318, f159, 0fBF3504F3;
mul.f32 f1319, f160, 0f3F3504F3;
sub.f32 f167, f1318, f1319;
mul.f32 f168, f160, 0fBF3504F3;
fma.rn.f32 f169, f159, 0f3F3504F3, f168;
add.f32 f170, f137, f153;
sub.f32 f172, f137, f153;
add.f32 f1317, f1328, f1321;
sub.f32 f173, f1328, f1321;
add.f32 f174, f141, f163;
sub.f32 f176, f141, f163;
add.f32 f1316, f1327, f164;
sub.f32 f177, f1327, f164;
sub.f32 f178, f139, f156;
add.f32 f180, f139, f156;
add.f32 f1315, f140, f155;
sub.f32 f181, f140, f155;
add.f32 f182, f143, f167;
sub.f32 f184, f143, f167;
add.f32 f1314, f144, f169;
sub.f32 f185, f144, f169;
add.f32 f186, %70, %102;
sub.f32 f188, %70, %102;
add.f32 f1312, %135, %103;
sub.f32 f189, %135, %103;
add.f32 f190, %86, %118;
sub.f32 f192, %86, %118;
add.f32 f1309, %137, %136;
sub.f32 f193, %137, %136;
add.f32 f194, f186, f190;
sub.f32 f196, f186, f190;
add.f32 f1308, f1312, f1309;
sub.f32 f197, f1312, f1309;
sub.f32 f198, f188, f193;
add.f32 f200, f188, f193;
add.f32 f1307, f189, f192;
sub.f32 f201, f189, f192;
add.f32 f202, %78, %110;
sub.f32 f204, %78, %110;
add.f32 f1305, %79, %138;
sub.f32 f205, %79, %138;
add.f32 f206, %94, %126;
sub.f32 f208, %94, %126;
add.f32 f1303, %139, %127;
sub.f32 f209, %139, %127;
add.f32 f210, f202, f206;
sub.f32 f212, f202, f206;
add.f32 f1302, f1305, f1303;
sub.f32 f213, f1305, f1303;
sub.f32 f214, f204, f209;
add.f32 f216, f204, f209;
add.f32 f1301, f205, f208;
sub.f32 f217, f205, f208;
mul.f32 f218, f214, 0f3F3504F3;
mul.f32 f219, f1301, 0f3F3504F3;
sub.f32 f220, f218, f219;
add.f32 f221, f218, f219;
mul.f32 f1299, f216, 0fBF3504F3;
mul.f32 f1300, f217, 0f3F3504F3;
sub.f32 f224, f1299, f1300;
mul.f32 f225, f217, 0fBF3504F3;
fma.rn.f32 f226, f216, 0f3F3504F3, f225;
add.f32 f227, f194, f210;
sub.f32 f229, f194, f210;
add.f32 f1298, f1308, f1302;
sub.f32 f230, f1308, f1302;
add.f32 f231, f198, f220;
sub.f32 f233, f198, f220;
add.f32 f1297, f1307, f221;
sub.f32 f234, f1307, f221;
sub.f32 f235, f196, f213;
add.f32 f237, f196, f213;
add.f32 f1296, f197, f212;
sub.f32 f238, f197, f212;
add.f32 f239, f200, f224;
sub.f32 f241, f200, f224;
add.f32 f1295, f201, f226;
sub.f32 f242, f201, f226;
mul.f32 f1293, f231, 0f3F6C835E;
mul.f32 f1294, f1297, 0f3EC3EF15;
sub.f32 f245, f1293, f1294;
mul.f32 f246, f1297, 0f3F6C835E;
fma.rn.f32 f247, f231, 0f3EC3EF15, f246;
mul.f32 f248, f235, 0f3F3504F3;
mul.f32 f249, f1296, 0f3F3504F3;
sub.f32 f250, f248, f249;
add.f32 f251, f248, f249;
mul.f32 f253, f1295, 0f3F6C835E;
mul.f32 f1292, f239, 0f3EC3EF15;
sub.f32 f254, f1292, f253;
mul.f32 f255, f1295, 0f3EC3EF15;
fma.rn.f32 f256, f239, 0f3F6C835E, f255;
mul.f32 f258, f234, 0f3F6C835E;
mul.f32 f1291, f233, 0fBEC3EF15;
sub.f32 f259, f1291, f258;
mul.f32 f260, f234, 0fBEC3EF15;
fma.rn.f32 f261, f233, 0f3F6C835E, f260;
mul.f32 f1289, f237, 0fBF3504F3;
mul.f32 f1290, f238, 0f3F3504F3;
sub.f32 f264, f1289, f1290;
mul.f32 f265, f238, 0fBF3504F3;
fma.rn.f32 f266, f237, 0f3F3504F3, f265;
mul.f32 f1287, f241, 0fBF6C835E;
mul.f32 f1288, f242, 0f3EC3EF15;
sub.f32 f269, f1287, f1288;
mul.f32 f270, f242, 0fBF6C835E;
fma.rn.f32 f271, f241, 0f3EC3EF15, f270;
add.f32 f272, f170, f227;
sub.f32 f274, f170, f227;
add.f32 f1286, f1317, f1298;
sub.f32 f275, f1317, f1298;
add.f32 f276, f174, f245;
sub.f32 f278, f174, f245;
add.f32 f1285, f1316, f247;
sub.f32 f279, f1316, f247;
add.f32 f280, f178, f250;
sub.f32 f282, f178, f250;
add.f32 f1284, f1315, f251;
sub.f32 f283, f1315, f251;
add.f32 f284, f182, f254;
sub.f32 f286, f182, f254;
add.f32 f1283, f1314, f256;
sub.f32 f287, f1314, f256;
sub.f32 f288, f172, f230;
add.f32 f290, f172, f230;
add.f32 f1282, f173, f229;
sub.f32 f291, f173, f229;
add.f32 f292, f176, f259;
sub.f32 f294, f176, f259;
add.f32 f1281, f177, f261;
sub.f32 f295, f177, f261;
add.f32 f296, f180, f264;
sub.f32 f298, f180, f264;
add.f32 f1280, f181, f266;
sub.f32 f299, f181, f266;
add.f32 f300, f184, f269;
sub.f32 f302, f184, f269;
add.f32 f1279, f185, f271;
sub.f32 f303, f185, f271;
add.f32 f304, %68, %100;
sub.f32 f306, %68, %100;
add.f32 f1276, %141, %140;
sub.f32 f307, %141, %140;
add.f32 f308, %84, %116;
sub.f32 f310, %84, %116;
add.f32 f1274, %85, %142;
sub.f32 f311, %85, %142;
add.f32 f312, f304, f308;
sub.f32 f314, f304, f308;
add.f32 f1273, f1276, f1274;
sub.f32 f315, f1276, f1274;
sub.f32 f316, f306, f311;
add.f32 f318, f306, f311;
add.f32 f1272, f307, f310;
sub.f32 f319, f307, f310;
add.f32 f320, %76, %108;
sub.f32 f322, %76, %108;
add.f32 f1270, %143, %109;
sub.f32 f323, %143, %109;
add.f32 f324, %92, %124;
sub.f32 f326, %92, %124;
add.f32 f1267, %145, %144;
sub.f32 f327, %145, %144;
add.f32 f328, f320, f324;
sub.f32 f330, f320, f324;
add.f32 f1266, f1270, f1267;
sub.f32 f331, f1270, f1267;
sub.f32 f332, f322, f327;
add.f32 f334, f322, f327;
add.f32 f1265, f323, f326;
sub.f32 f335, f323, f326;
mul.f32 f336, f332, 0f3F3504F3;
mul.f32 f337, f1265, 0f3F3504F3;
sub.f32 f338, f336, f337;
add.f32 f339, f336, f337;
mul.f32 f341, f335, 0f3F3504F3;
mul.f32 f1264, f334, 0fBF3504F3;
sub.f32 f342, f1264, f341;
mul.f32 f343, f335, 0fBF3504F3;
fma.rn.f32 f344, f334, 0f3F3504F3, f343;
add.f32 f345, f312, f328;
sub.f32 f347, f312, f328;
add.f32 f1263, f1273, f1266;
sub.f32 f348, f1273, f1266;
add.f32 f349, f316, f338;
sub.f32 f351, f316, f338;
add.f32 f1262, f1272, f339;
sub.f32 f352, f1272, f339;
sub.f32 f353, f314, f331;
add.f32 f355, f314, f331;
add.f32 f1261, f315, f330;
sub.f32 f356, f315, f330;
add.f32 f357, f318, f342;
sub.f32 f359, f318, f342;
add.f32 f1260, f319, f344;
sub.f32 f360, f319, f344;
add.f32 f361, %72, %104;
sub.f32 f363, %72, %104;
add.f32 f1258, %73, %146;
sub.f32 f364, %73, %146;
add.f32 f365, %88, %120;
sub.f32 f367, %88, %120;
add.f32 f1256, %147, %121;
sub.f32 f368, %147, %121;
add.f32 f369, f361, f365;
sub.f32 f371, f361, f365;
add.f32 f1255, f1258, f1256;
sub.f32 f372, f1258, f1256;
sub.f32 f373, f363, f368;
add.f32 f375, f363, f368;
add.f32 f1254, f364, f367;
sub.f32 f376, f364, f367;
add.f32 f377, %80, %112;
sub.f32 f379, %80, %112;
add.f32 f1251, %149, %148;
sub.f32 f380, %149, %148;
add.f32 f381, %96, %128;
sub.f32 f383, %96, %128;
add.f32 f1250, %97, %129;
sub.f32 f384, %97, %129;
add.f32 f385, f377, f381;
sub.f32 f387, f377, f381;
add.f32 f1249, f1251, f1250;
sub.f32 f388, f1251, f1250;
sub.f32 f389, f379, f384;
add.f32 f391, f379, f384;
add.f32 f1248, f380, f383;
sub.f32 f392, f380, f383;
mul.f32 f393, f389, 0f3F3504F3;
mul.f32 f394, f1248, 0f3F3504F3;
sub.f32 f395, f393, f394;
add.f32 f396, f393, f394;
mul.f32 f1246, f391, 0fBF3504F3;
mul.f32 f1247, f392, 0f3F3504F3;
sub.f32 f399, f1246, f1247;
mul.f32 f400, f392, 0fBF3504F3;
fma.rn.f32 f401, f391, 0f3F3504F3, f400;
add.f32 f402, f369, f385;
sub.f32 f404, f369, f385;
add.f32 f1245, f1255, f1249;
sub.f32 f405, f1255, f1249;
add.f32 f406, f373, f395;
sub.f32 f408, f373, f395;
add.f32 f1244, f1254, f396;
sub.f32 f409, f1254, f396;
sub.f32 f410, f371, f388;
add.f32 f412, f371, f388;
add.f32 f1243, f372, f387;
sub.f32 f413, f372, f387;
add.f32 f414, f375, f399;
sub.f32 f416, f375, f399;
add.f32 f1242, f376, f401;
sub.f32 f417, f376, f401;
mul.f32 f419, f1244, 0f3EC3EF15;
mul.f32 f1241, f406, 0f3F6C835E;
sub.f32 f420, f1241, f419;
mul.f32 f421, f1244, 0f3F6C835E;
fma.rn.f32 f422, f406, 0f3EC3EF15, f421;
mul.f32 f423, f410, 0f3F3504F3;
mul.f32 f424, f1243, 0f3F3504F3;
sub.f32 f425, f423, f424;
add.f32 f426, f423, f424;
mul.f32 f428, f1242, 0f3F6C835E;
mul.f32 f1240, f414, 0f3EC3EF15;
sub.f32 f429, f1240, f428;
mul.f32 f430, f1242, 0f3EC3EF15;
fma.rn.f32 f431, f414, 0f3F6C835E, f430;
mul.f32 f433, f409, 0f3F6C835E;
mul.f32 f1239, f408, 0fBEC3EF15;
sub.f32 f434, f1239, f433;
mul.f32 f435, f409, 0fBEC3EF15;
fma.rn.f32 f436, f408, 0f3F6C835E, f435;
mul.f32 f438, f413, 0f3F3504F3;
mul.f32 f1238, f412, 0fBF3504F3;
sub.f32 f439, f1238, f438;
mul.f32 f440, f413, 0fBF3504F3;
fma.rn.f32 f441, f412, 0f3F3504F3, f440;
mul.f32 f443, f417, 0f3EC3EF15;
mul.f32 f1237, f416, 0fBF6C835E;
sub.f32 f444, f1237, f443;
mul.f32 f445, f417, 0fBF6C835E;
fma.rn.f32 f446, f416, 0f3EC3EF15, f445;
add.f32 f447, f345, f402;
sub.f32 f449, f345, f402;
add.f32 f1236, f1263, f1245;
sub.f32 f450, f1263, f1245;
add.f32 f451, f349, f420;
sub.f32 f453, f349, f420;
add.f32 f1235, f1262, f422;
sub.f32 f454, f1262, f422;
add.f32 f455, f353, f425;
sub.f32 f457, f353, f425;
add.f32 f1234, f1261, f426;
sub.f32 f458, f1261, f426;
add.f32 f459, f357, f429;
sub.f32 f461, f357, f429;
add.f32 f1233, f1260, f431;
sub.f32 f462, f1260, f431;
sub.f32 f463, f347, f405;
add.f32 f465, f347, f405;
add.f32 f1232, f348, f404;
sub.f32 f466, f348, f404;
add.f32 f467, f351, f434;
sub.f32 f469, f351, f434;
add.f32 f1231, f352, f436;
sub.f32 f470, f352, f436;
add.f32 f471, f355, f439;
sub.f32 f473, f355, f439;
add.f32 f1230, f356, f441;
sub.f32 f474, f356, f441;
add.f32 f475, f359, f444;
sub.f32 f477, f359, f444;
add.f32 f1229, f360, f446;
sub.f32 f478, f360, f446;
mul.f32 f480, f1235, 0f3E47C5C2;
mul.f32 f1228, f451, 0f3F7B14BE;
sub.f32 f481, f1228, f480;
mul.f32 f482, f1235, 0f3F7B14BE;
fma.rn.f32 f483, f451, 0f3E47C5C2, f482;
mul.f32 f485, f1234, 0f3EC3EF15;
mul.f32 f1227, f455, 0f3F6C835E;
sub.f32 f486, f1227, f485;
mul.f32 f487, f1234, 0f3F6C835E;
fma.rn.f32 f488, f455, 0f3EC3EF15, f487;
mul.f32 f490, f1233, 0f3F0E39DA;
mul.f32 f1226, f459, 0f3F54DB31;
sub.f32 f491, f1226, f490;
mul.f32 f492, f1233, 0f3F54DB31;
fma.rn.f32 f493, f459, 0f3F0E39DA, f492;
mul.f32 f494, f463, 0f3F3504F3;
mul.f32 f495, f1232, 0f3F3504F3;
sub.f32 f496, f494, f495;
add.f32 f497, f494, f495;
mul.f32 f499, f1231, 0f3F54DB31;
mul.f32 f1225, f467, 0f3F0E39DA;
sub.f32 f500, f1225, f499;
mul.f32 f501, f1231, 0f3F0E39DA;
fma.rn.f32 f502, f467, 0f3F54DB31, f501;
mul.f32 f504, f1230, 0f3F6C835E;
mul.f32 f1224, f471, 0f3EC3EF15;
sub.f32 f505, f1224, f504;
mul.f32 f506, f1230, 0f3EC3EF15;
fma.rn.f32 f507, f471, 0f3F6C835E, f506;
mul.f32 f509, f1229, 0f3F7B14BE;
mul.f32 f1223, f475, 0f3E47C5C2;
sub.f32 f510, f1223, f509;
mul.f32 f511, f1229, 0f3E47C5C2;
fma.rn.f32 f512, f475, 0f3F7B14BE, f511;
mul.f32 f514, f454, 0f3F7B14BE;
mul.f32 f1222, f453, 0fBE47C5C2;
sub.f32 f515, f1222, f514;
mul.f32 f516, f454, 0fBE47C5C2;
fma.rn.f32 f517, f453, 0f3F7B14BE, f516;
mul.f32 f1220, f457, 0fBEC3EF15;
mul.f32 f1221, f458, 0f3F6C835E;
sub.f32 f520, f1220, f1221;
mul.f32 f521, f458, 0fBEC3EF15;
fma.rn.f32 f522, f457, 0f3F6C835E, f521;
mul.f32 f1218, f461, 0fBF0E39DA;
mul.f32 f1219, f462, 0f3F54DB31;
sub.f32 f525, f1218, f1219;
mul.f32 f526, f462, 0fBF0E39DA;
fma.rn.f32 f527, f461, 0f3F54DB31, f526;
mul.f32 f1216, f465, 0fBF3504F3;
mul.f32 f1217, f466, 0f3F3504F3;
sub.f32 f530, f1216, f1217;
mul.f32 f531, f466, 0fBF3504F3;
fma.rn.f32 f532, f465, 0f3F3504F3, f531;
mul.f32 f1214, f469, 0fBF54DB31;
mul.f32 f1215, f470, 0f3F0E39DA;
sub.f32 f535, f1214, f1215;
mul.f32 f536, f470, 0fBF54DB31;
fma.rn.f32 f537, f469, 0f3F0E39DA, f536;
mul.f32 f539, f474, 0f3EC3EF15;
mul.f32 f1213, f473, 0fBF6C835E;
sub.f32 f540, f1213, f539;
mul.f32 f541, f474, 0fBF6C835E;
fma.rn.f32 f542, f473, 0f3EC3EF15, f541;
mul.f32 f544, f478, 0f3E47C5C2;
mul.f32 f1212, f477, 0fBF7B14BE;
sub.f32 f545, f1212, f544;
mul.f32 f546, f478, 0fBF7B14BE;
fma.rn.f32 f547, f477, 0f3E47C5C2, f546;
add.f32 f548, f272, f447;
sub.f32 f550, f272, f447;
add.f32 f1211, f1286, f1236;
sub.f32 f551, f1286, f1236;
add.f32 f552, f276, f481;
sub.f32 f554, f276, f481;
add.f32 f1210, f1285, f483;
sub.f32 f555, f1285, f483;
add.f32 f556, f280, f486;
sub.f32 f558, f280, f486;
add.f32 f1209, f1284, f488;
sub.f32 f559, f1284, f488;
add.f32 f560, f284, f491;
sub.f32 f562, f284, f491;
add.f32 f1208, f1283, f493;
sub.f32 f563, f1283, f493;
add.f32 f564, f288, f496;
sub.f32 f566, f288, f496;
add.f32 f1207, f1282, f497;
sub.f32 f567, f1282, f497;
add.f32 f568, f292, f500;
sub.f32 f570, f292, f500;
add.f32 f1206, f1281, f502;
sub.f32 f571, f1281, f502;
add.f32 f572, f296, f505;
sub.f32 f574, f296, f505;
add.f32 f1205, f1280, f507;
sub.f32 f575, f1280, f507;
add.f32 f576, f300, f510;
sub.f32 f578, f300, f510;
add.f32 f1204, f1279, f512;
sub.f32 f579, f1279, f512;
sub.f32 f580, f274, f450;
add.f32 f582, f274, f450;
add.f32 f1203, f275, f449;
sub.f32 f583, f275, f449;
add.f32 f584, f278, f515;
sub.f32 f586, f278, f515;
add.f32 f1202, f279, f517;
sub.f32 f587, f279, f517;
add.f32 f588, f282, f520;
sub.f32 f590, f282, f520;
add.f32 f1201, f283, f522;
sub.f32 f591, f283, f522;
add.f32 f592, f286, f525;
sub.f32 f594, f286, f525;
add.f32 f1200, f287, f527;
sub.f32 f595, f287, f527;
add.f32 f596, f290, f530;
sub.f32 f598, f290, f530;
add.f32 f1199, f291, f532;
sub.f32 f599, f291, f532;
add.f32 f600, f294, f535;
sub.f32 f602, f294, f535;
add.f32 f1198, f295, f537;
sub.f32 f603, f295, f537;
add.f32 f604, f298, f540;
sub.f32 f606, f298, f540;
add.f32 f1197, f299, f542;
sub.f32 f607, f299, f542;
add.f32 f608, f302, f545;
sub.f32 f610, f302, f545;
add.f32 f1196, f303, f547;
sub.f32 f611, f303, f547;
mov.u32 r15, %tid.x;
shl.b32 r7, r15, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 24;
mov.u64 rd4, %65;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f612, f613}, [rd5];
mul.f32 f616, f1210, f613;
fma.rn.f32 f617, f612, f552, f616;
mul.f32 f618, f552, f613;
mul.f32 f619, f612, f1210;
sub.f32 f620, f619, f618;
mul.f32 f1194, f612, f612;
mul.f32 f1195, f613, f613;
sub.f32 f623, f1194, f1195;
mul.f32 f624, f613, f612;
fma.rn.f32 f625, f613, f612, f624;
mul.f32 f626, f1209, f625;
fma.rn.f32 f627, f623, f556, f626;
mul.f32 f628, f556, f625;
mul.f32 f629, f623, f1209;
sub.f32 f630, f629, f628;
mul.f32 f1192, f612, f623;
mul.f32 f1193, f613, f625;
sub.f32 f633, f1192, f1193;
mul.f32 f634, f612, f625;
fma.rn.f32 f635, f613, f623, f634;
mul.f32 f636, f1208, f635;
fma.rn.f32 f637, f633, f560, f636;
mul.f32 f638, f560, f635;
mul.f32 f639, f633, f1208;
sub.f32 f640, f639, f638;
mul.f32 f642, f613, f635;
mul.f32 f1191, f612, f633;
sub.f32 f643, f1191, f642;
mul.f32 f644, f612, f635;
fma.rn.f32 f645, f613, f633, f644;
mul.f32 f646, f1207, f645;
fma.rn.f32 f647, f643, f564, f646;
mul.f32 f648, f564, f645;
mul.f32 f649, f643, f1207;
sub.f32 f650, f649, f648;
mul.f32 f652, f613, f645;
mul.f32 f1190, f612, f643;
sub.f32 f653, f1190, f652;
mul.f32 f654, f612, f645;
fma.rn.f32 f655, f613, f643, f654;
mul.f32 f656, f1206, f655;
fma.rn.f32 f657, f653, f568, f656;
mul.f32 f658, f568, f655;
mul.f32 f659, f653, f1206;
sub.f32 f660, f659, f658;
mul.f32 f662, f613, f655;
mul.f32 f1189, f612, f653;
sub.f32 f663, f1189, f662;
mul.f32 f664, f612, f655;
fma.rn.f32 f665, f613, f653, f664;
mul.f32 f666, f1205, f665;
fma.rn.f32 f667, f663, f572, f666;
mul.f32 f668, f572, f665;
mul.f32 f669, f663, f1205;
sub.f32 f670, f669, f668;
mul.f32 f1187, f612, f663;
mul.f32 f1188, f613, f665;
sub.f32 f673, f1187, f1188;
mul.f32 f674, f612, f665;
fma.rn.f32 f675, f613, f663, f674;
mul.f32 f676, f1204, f675;
fma.rn.f32 f677, f673, f576, f676;
mul.f32 f678, f576, f675;
mul.f32 f679, f673, f1204;
sub.f32 f680, f679, f678;
mul.f32 f1185, f612, f673;
mul.f32 f1186, f613, f675;
sub.f32 f683, f1185, f1186;
mul.f32 f684, f612, f675;
fma.rn.f32 f685, f613, f673, f684;
mul.f32 f686, f1203, f685;
fma.rn.f32 f687, f683, f580, f686;
mul.f32 f688, f580, f685;
mul.f32 f689, f683, f1203;
sub.f32 f690, f689, f688;
mul.f32 f692, f613, f685;
mul.f32 f1184, f612, f683;
sub.f32 f693, f1184, f692;
mul.f32 f694, f612, f685;
fma.rn.f32 f695, f613, f683, f694;
mul.f32 f696, f1202, f695;
fma.rn.f32 f697, f693, f584, f696;
mul.f32 f698, f584, f695;
mul.f32 f699, f693, f1202;
sub.f32 f700, f699, f698;
mul.f32 f702, f613, f695;
mul.f32 f1183, f612, f693;
sub.f32 f703, f1183, f702;
mul.f32 f704, f612, f695;
fma.rn.f32 f705, f613, f693, f704;
mul.f32 f706, f1201, f705;
fma.rn.f32 f707, f703, f588, f706;
mul.f32 f708, f588, f705;
mul.f32 f709, f703, f1201;
sub.f32 f710, f709, f708;
mul.f32 f1181, f612, f703;
mul.f32 f1182, f613, f705;
sub.f32 f713, f1181, f1182;
mul.f32 f714, f612, f705;
fma.rn.f32 f715, f613, f703, f714;
mul.f32 f716, f1200, f715;
fma.rn.f32 f717, f713, f592, f716;
mul.f32 f718, f592, f715;
mul.f32 f719, f713, f1200;
sub.f32 f720, f719, f718;
mul.f32 f1179, f612, f713;
mul.f32 f1180, f613, f715;
sub.f32 f723, f1179, f1180;
mul.f32 f724, f612, f715;
fma.rn.f32 f725, f613, f713, f724;
mul.f32 f726, f1199, f725;
fma.rn.f32 f727, f723, f596, f726;
mul.f32 f728, f596, f725;
mul.f32 f729, f723, f1199;
sub.f32 f730, f729, f728;
mul.f32 f732, f613, f725;
mul.f32 f1178, f612, f723;
sub.f32 f733, f1178, f732;
mul.f32 f734, f612, f725;
fma.rn.f32 f735, f613, f723, f734;
mul.f32 f736, f1198, f735;
fma.rn.f32 f737, f733, f600, f736;
mul.f32 f738, f600, f735;
mul.f32 f739, f733, f1198;
sub.f32 f740, f739, f738;
mul.f32 f742, f613, f735;
mul.f32 f1177, f612, f733;
sub.f32 f743, f1177, f742;
mul.f32 f744, f612, f735;
fma.rn.f32 f745, f613, f733, f744;
mul.f32 f746, f1197, f745;
fma.rn.f32 f747, f743, f604, f746;
mul.f32 f748, f604, f745;
mul.f32 f749, f743, f1197;
sub.f32 f750, f749, f748;
mul.f32 f752, f613, f745;
mul.f32 f1176, f612, f743;
sub.f32 f753, f1176, f752;
mul.f32 f754, f612, f745;
fma.rn.f32 f755, f613, f743, f754;
mul.f32 f756, f1196, f755;
fma.rn.f32 f757, f753, f608, f756;
mul.f32 f758, f608, f755;
mul.f32 f759, f753, f1196;
sub.f32 f760, f759, f758;
mul.f32 f1174, f612, f753;
mul.f32 f1175, f613, f755;
sub.f32 f763, f1174, f1175;
mul.f32 f764, f612, f755;
fma.rn.f32 f765, f613, f753, f764;
mul.f32 f766, f551, f765;
fma.rn.f32 f767, f763, f550, f766;
mul.f32 f768, f550, f765;
mul.f32 f769, f763, f551;
sub.f32 f770, f769, f768;
mul.f32 f1172, f612, f763;
mul.f32 f1173, f613, f765;
sub.f32 f773, f1172, f1173;
mul.f32 f774, f612, f765;
fma.rn.f32 f775, f613, f763, f774;
mul.f32 f776, f555, f775;
fma.rn.f32 f777, f773, f554, f776;
mul.f32 f778, f554, f775;
mul.f32 f779, f773, f555;
sub.f32 f780, f779, f778;
mul.f32 f782, f613, f775;
mul.f32 f1171, f612, f773;
sub.f32 f783, f1171, f782;
mul.f32 f784, f612, f775;
fma.rn.f32 f785, f613, f773, f784;
mul.f32 f786, f559, f785;
fma.rn.f32 f787, f783, f558, f786;
mul.f32 f788, f558, f785;
mul.f32 f789, f783, f559;
sub.f32 f790, f789, f788;
mul.f32 f792, f613, f785;
mul.f32 f1170, f612, f783;
sub.f32 f793, f1170, f792;
mul.f32 f794, f612, f785;
fma.rn.f32 f795, f613, f783, f794;
mul.f32 f796, f563, f795;
fma.rn.f32 f797, f793, f562, f796;
mul.f32 f798, f562, f795;
mul.f32 f799, f793, f563;
sub.f32 f800, f799, f798;
mul.f32 f802, f613, f795;
mul.f32 f1169, f612, f793;
sub.f32 f803, f1169, f802;
mul.f32 f804, f612, f795;
fma.rn.f32 f805, f613, f793, f804;
mul.f32 f806, f567, f805;
fma.rn.f32 f807, f803, f566, f806;
mul.f32 f808, f566, f805;
mul.f32 f809, f803, f567;
sub.f32 f810, f809, f808;
mul.f32 f1167, f612, f803;
mul.f32 f1168, f613, f805;
sub.f32 f813, f1167, f1168;
mul.f32 f814, f612, f805;
fma.rn.f32 f815, f613, f803, f814;
mul.f32 f816, f571, f815;
fma.rn.f32 f817, f813, f570, f816;
mul.f32 f818, f570, f815;
mul.f32 f819, f813, f571;
sub.f32 f820, f819, f818;
mul.f32 f1165, f612, f813;
mul.f32 f1166, f613, f815;
sub.f32 f823, f1165, f1166;
mul.f32 f824, f612, f815;
fma.rn.f32 f825, f613, f813, f824;
mul.f32 f826, f575, f825;
fma.rn.f32 f827, f823, f574, f826;
mul.f32 f828, f574, f825;
mul.f32 f829, f823, f575;
sub.f32 f830, f829, f828;
mul.f32 f832, f613, f825;
mul.f32 f1164, f612, f823;
sub.f32 f833, f1164, f832;
mul.f32 f834, f612, f825;
fma.rn.f32 f835, f613, f823, f834;
mul.f32 f836, f579, f835;
fma.rn.f32 f837, f833, f578, f836;
mul.f32 f838, f578, f835;
mul.f32 f839, f833, f579;
sub.f32 f840, f839, f838;
mul.f32 f842, f613, f835;
mul.f32 f1163, f612, f833;
sub.f32 f843, f1163, f842;
mul.f32 f844, f612, f835;
fma.rn.f32 f845, f613, f833, f844;
mul.f32 f846, f583, f845;
fma.rn.f32 f847, f843, f582, f846;
mul.f32 f848, f582, f845;
mul.f32 f849, f843, f583;
sub.f32 f850, f849, f848;
mul.f32 f1161, f612, f843;
mul.f32 f1162, f613, f845;
sub.f32 f853, f1161, f1162;
mul.f32 f854, f612, f845;
fma.rn.f32 f855, f613, f843, f854;
mul.f32 f856, f587, f855;
fma.rn.f32 f857, f853, f586, f856;
mul.f32 f858, f586, f855;
mul.f32 f859, f853, f587;
sub.f32 f860, f859, f858;
mul.f32 f1159, f612, f853;
mul.f32 f1160, f613, f855;
sub.f32 f863, f1159, f1160;
mul.f32 f864, f612, f855;
fma.rn.f32 f865, f613, f853, f864;
mul.f32 f866, f591, f865;
fma.rn.f32 f867, f863, f590, f866;
mul.f32 f868, f590, f865;
mul.f32 f869, f863, f591;
sub.f32 f870, f869, f868;
mul.f32 f872, f613, f865;
mul.f32 f1158, f612, f863;
sub.f32 f873, f1158, f872;
mul.f32 f874, f612, f865;
fma.rn.f32 f875, f613, f863, f874;
mul.f32 f876, f595, f875;
fma.rn.f32 f877, f873, f594, f876;
mul.f32 f878, f594, f875;
mul.f32 f879, f873, f595;
sub.f32 f880, f879, f878;
mul.f32 f882, f613, f875;
mul.f32 f1157, f612, f873;
sub.f32 f883, f1157, f882;
mul.f32 f884, f612, f875;
fma.rn.f32 f885, f613, f873, f884;
mul.f32 f886, f599, f885;
fma.rn.f32 f887, f883, f598, f886;
mul.f32 f888, f598, f885;
mul.f32 f889, f883, f599;
sub.f32 f890, f889, f888;
mul.f32 f892, f613, f885;
mul.f32 f1156, f612, f883;
sub.f32 f893, f1156, f892;
mul.f32 f894, f612, f885;
fma.rn.f32 f895, f613, f883, f894;
mul.f32 f896, f603, f895;
fma.rn.f32 f897, f893, f602, f896;
mul.f32 f898, f602, f895;
mul.f32 f899, f893, f603;
sub.f32 f900, f899, f898;
mul.f32 f1154, f612, f893;
mul.f32 f1155, f613, f895;
sub.f32 f903, f1154, f1155;
mul.f32 f904, f612, f895;
fma.rn.f32 f905, f613, f893, f904;
mul.f32 f906, f607, f905;
fma.rn.f32 f907, f903, f606, f906;
mul.f32 f908, f606, f905;
mul.f32 f909, f903, f607;
sub.f32 f910, f909, f908;
mul.f32 f1152, f612, f903;
mul.f32 f1153, f613, f905;
sub.f32 f913, f1152, f1153;
mul.f32 f914, f612, f905;
fma.rn.f32 f915, f613, f903, f914;
mov.u32 r17, %tid.x;
mul.f32 f916, f611, f915;
fma.rn.f32 f917, f913, f610, f916;
mul.f32 f918, f610, f915;
mul.f32 f919, f913, f611;
sub.f32 f920, f919, f918;
and.b32 r14, r17, 3;
shl.b32 r8, r17, 7;
and.b32 r9, r8, -512;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 384;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f548, f617, f627, f637};
st.shared.v4.f32 [r12+16], {f647, f657, f667, f677};
st.shared.v4.f32 [r12+32], {f687, f697, f707, f717};
st.shared.v4.f32 [r12+48], {f727, f737, f747, f757};
st.shared.v4.f32 [r12+64], {f767, f777, f787, f797};
st.shared.v4.f32 [r12+80], {f807, f817, f827, f837};
st.shared.v4.f32 [r12+96], {f847, f857, f867, f877};
st.shared.v4.f32 [r12+112], {f887, f897, f907, f917};
barrier.sync 0;
mad.lo.s32 r13, r14, -124, r12;
ld.shared.f32 f921, [r13];
ld.shared.f32 f922, [r13+16];
ld.shared.f32 f923, [r13+32];
ld.shared.f32 f924, [r13+48];
ld.shared.f32 f925, [r13+64];
ld.shared.f32 f926, [r13+80];
ld.shared.f32 f927, [r13+96];
ld.shared.f32 f928, [r13+112];
ld.shared.f32 f929, [r13+128];
ld.shared.f32 f930, [r13+144];
ld.shared.f32 f931, [r13+160];
ld.shared.f32 f932, [r13+176];
ld.shared.f32 f933, [r13+192];
ld.shared.f32 f934, [r13+208];
ld.shared.f32 f935, [r13+224];
ld.shared.f32 f936, [r13+240];
ld.shared.f32 f937, [r13+256];
ld.shared.f32 f938, [r13+272];
ld.shared.f32 f939, [r13+288];
ld.shared.f32 f940, [r13+304];
ld.shared.f32 f941, [r13+320];
ld.shared.f32 f942, [r13+336];
ld.shared.f32 f943, [r13+352];
ld.shared.f32 f944, [r13+368];
ld.shared.f32 f945, [r13+384];
ld.shared.f32 f946, [r13+400];
ld.shared.f32 f947, [r13+416];
ld.shared.f32 f948, [r13+432];
ld.shared.f32 f949, [r13+448];
ld.shared.f32 f950, [r13+464];
ld.shared.f32 f951, [r13+480];
ld.shared.f32 f952, [r13+496];
barrier.sync 0;
st.shared.v4.f32 [r12], {f1211, f620, f630, f640};
st.shared.v4.f32 [r12+16], {f650, f660, f670, f680};
st.shared.v4.f32 [r12+32], {f690, f700, f710, f720};
st.shared.v4.f32 [r12+48], {f730, f740, f750, f760};
st.shared.v4.f32 [r12+64], {f770, f780, f790, f800};
st.shared.v4.f32 [r12+80], {f810, f820, f830, f840};
st.shared.v4.f32 [r12+96], {f850, f860, f870, f880};
st.shared.v4.f32 [r12+112], {f890, f900, f910, f920};
barrier.sync 0;
ld.shared.f32 f953, [r13];
ld.shared.f32 f954, [r13+16];
ld.shared.f32 f955, [r13+32];
ld.shared.f32 f956, [r13+48];
ld.shared.f32 f957, [r13+64];
ld.shared.f32 f958, [r13+80];
ld.shared.f32 f959, [r13+96];
ld.shared.f32 f960, [r13+112];
ld.shared.f32 f961, [r13+128];
ld.shared.f32 f962, [r13+144];
ld.shared.f32 f963, [r13+160];
ld.shared.f32 f964, [r13+176];
ld.shared.f32 f965, [r13+192];
ld.shared.f32 f966, [r13+208];
ld.shared.f32 f967, [r13+224];
ld.shared.f32 f968, [r13+240];
ld.shared.f32 f969, [r13+256];
ld.shared.f32 f970, [r13+272];
ld.shared.f32 f971, [r13+288];
ld.shared.f32 f972, [r13+304];
ld.shared.f32 f973, [r13+320];
ld.shared.f32 f974, [r13+336];
ld.shared.f32 f975, [r13+352];
ld.shared.f32 f976, [r13+368];
ld.shared.f32 f977, [r13+384];
ld.shared.f32 f978, [r13+400];
ld.shared.f32 f979, [r13+416];
ld.shared.f32 f980, [r13+432];
ld.shared.f32 f981, [r13+448];
ld.shared.f32 f982, [r13+464];
ld.shared.f32 f983, [r13+480];
ld.shared.f32 f984, [r13+496];
add.f32 f985, f921, f937;
sub.f32 f987, f921, f937;
add.f32 f1151, f953, f969;
sub.f32 f988, f953, f969;
add.f32 f989, f929, f945;
sub.f32 f991, f929, f945;
add.f32 f1150, f961, f977;
sub.f32 f992, f961, f977;
add.f32 f993, f922, f938;
sub.f32 f995, f922, f938;
add.f32 f1149, f954, f970;
sub.f32 f996, f954, f970;
add.f32 f997, f930, f946;
sub.f32 f999, f930, f946;
add.f32 f1148, f962, f978;
sub.f32 f1000, f962, f978;
add.f32 f1001, f923, f939;
sub.f32 f1003, f923, f939;
add.f32 f1147, f955, f971;
sub.f32 f1004, f955, f971;
add.f32 f1005, f931, f947;
sub.f32 f1007, f931, f947;
add.f32 f1146, f963, f979;
sub.f32 f1008, f963, f979;
add.f32 f1009, f924, f940;
sub.f32 f1011, f924, f940;
add.f32 f1145, f956, f972;
sub.f32 f1012, f956, f972;
add.f32 f1013, f932, f948;
sub.f32 f1015, f932, f948;
add.f32 f1144, f964, f980;
sub.f32 f1016, f964, f980;
add.f32 f1017, f925, f941;
sub.f32 f1019, f925, f941;
add.f32 f1143, f957, f973;
sub.f32 f1020, f957, f973;
add.f32 f1021, f933, f949;
sub.f32 f1023, f933, f949;
add.f32 f1142, f965, f981;
sub.f32 f1024, f965, f981;
add.f32 f1025, f926, f942;
sub.f32 f1027, f926, f942;
add.f32 f1141, f958, f974;
sub.f32 f1028, f958, f974;
add.f32 f1029, f934, f950;
sub.f32 f1031, f934, f950;
add.f32 f1140, f966, f982;
sub.f32 f1032, f966, f982;
add.f32 f1033, f927, f943;
sub.f32 f1035, f927, f943;
add.f32 f1139, f959, f975;
sub.f32 f1036, f959, f975;
add.f32 f1037, f935, f951;
sub.f32 f1039, f935, f951;
add.f32 f1138, f967, f983;
sub.f32 f1040, f967, f983;
add.f32 f1041, f928, f944;
sub.f32 f1043, f928, f944;
add.f32 f1137, f960, f976;
sub.f32 f1044, f960, f976;
add.f32 f1045, f936, f952;
sub.f32 f1047, f936, f952;
add.f32 f1136, f968, f984;
sub.f32 f1048, f968, f984;
add.f32 %0, f985, f989;
add.f32 %1, f1151, f1150;
add.f32 %3, f1149, f1148;
add.f32 %2, f993, f997;
add.f32 %5, f1147, f1146;
add.f32 %4, f1001, f1005;
add.f32 %7, f1145, f1144;
add.f32 %6, f1009, f1013;
add.f32 %9, f1143, f1142;
add.f32 %8, f1017, f1021;
add.f32 %10, f1025, f1029;
add.f32 %11, f1141, f1140;
add.f32 %12, f1033, f1037;
add.f32 %13, f1139, f1138;
add.f32 %14, f1041, f1045;
add.f32 %15, f1137, f1136;
sub.f32 %16, f987, f992;
add.f32 %17, f988, f991;
sub.f32 %18, f995, f1000;
add.f32 %19, f996, f999;
sub.f32 %20, f1003, f1008;
add.f32 %21, f1004, f1007;
add.f32 %23, f1012, f1015;
sub.f32 %22, f1011, f1016;
add.f32 %25, f1020, f1023;
sub.f32 %24, f1019, f1024;
add.f32 %27, f1028, f1031;
sub.f32 %26, f1027, f1032;
sub.f32 %28, f1035, f1040;
add.f32 %29, f1036, f1039;
sub.f32 %30, f1043, f1048;
add.f32 %31, f1044, f1047;
sub.f32 %32, f985, f989;
sub.f32 %33, f1151, f1150;
sub.f32 %34, f993, f997;
sub.f32 %35, f1149, f1148;
sub.f32 %36, f1001, f1005;
sub.f32 %37, f1147, f1146;
sub.f32 %38, f1009, f1013;
sub.f32 %39, f1145, f1144;
sub.f32 %40, f1017, f1021;
sub.f32 %41, f1143, f1142;
sub.f32 %42, f1025, f1029;
sub.f32 %43, f1141, f1140;
sub.f32 %44, f1033, f1037;
sub.f32 %45, f1139, f1138;
sub.f32 %46, f1041, f1045;
sub.f32 %47, f1137, f1136;
sub.f32 %49, f988, f991;
add.f32 %48, f987, f992;
sub.f32 %51, f996, f999;
add.f32 %50, f995, f1000;
sub.f32 %53, f1004, f1007;
add.f32 %52, f1003, f1008;
sub.f32 %55, f1012, f1015;
add.f32 %54, f1011, f1016;
sub.f32 %57, f1020, f1023;
add.f32 %56, f1019, f1024;
sub.f32 %59, f1028, f1031;
add.f32 %58, f1027, f1032;
sub.f32 %61, f1036, f1039;
add.f32 %60, f1035, f1040;
sub.f32 %63, f1044, f1047;
add.f32 %62, f1043, f1048;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y), "=f"(rmem[27].x), "=f"(rmem[27].y), "=f"(rmem[28].x), "=f"(rmem[28].y), "=f"(rmem[29].x), "=f"(rmem[29].y), "=f"(rmem[30].x), "=f"(rmem[30].y), "=f"(rmem[31].x), "=f"(rmem[31].y): "r"(smem), "l"(lut_sp_32_128), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[27].x), "f"(rmem[27].y), "f"(rmem[28].x), "f"(rmem[28].y), "f"(rmem[29].x), "f"(rmem[29].y), "f"(rmem[30].x), "f"(rmem[30].y), "f"(rmem[31].x), "f"(rmem[31].y), "f"(rmem[16].y), "f"(rmem[8].y), "f"(rmem[20].y), "f"(rmem[4].y), "f"(rmem[28].y), "f"(rmem[2].y), "f"(rmem[26].y), "f"(rmem[10].y), "f"(rmem[22].y), "f"(rmem[14].y), "f"(rmem[17].y), "f"(rmem[1].y), "f"(rmem[25].y), "f"(rmem[5].y), "f"(rmem[29].y), "f"(rmem[13].y), "f"(rmem[19].y), "f"(rmem[11].y), "f"(rmem[23].y), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<261, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<139>;
.reg .b32 r<49>;
.reg .b64 rd<21>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 10;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
sub.f32 f9, %11, %13;
sub.f32 f10, %12, %14;
shl.b32 r6, r5, 4;
and.b32 r7, r6, -1024;
add.s32 r8, r4, r7;
shl.b32 r9, r5, 3;
cvt.u64.u32 rd2, r9;
and.b64 rd3, rd2, 504;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f11, f12}, [rd5];
mul.f32 f15, f10, f12;
mul.f32 f16, f9, f12;
mul.f32 f17, f11, f10;
barrier.sync 0;
and.b32 r10, r6, 1008;
add.s32 r11, r8, r10;
add.f32 f18, %12, %14;
add.f32 f19, %11, %13;
st.shared.v2.f32 [r11], {f19, f18};
sub.f32 f20, f17, f16;
fma.rn.f32 f21, f11, f9, f15;
st.shared.v2.f32 [r11+8], {f21, f20};
barrier.sync 0;
and.b32 r12, r9, 504;
sub.s32 r13, r11, r12;
ld.shared.v2.f32 {f22, f23}, [r13];
ld.shared.v2.f32 {f26, f27}, [r13+512];
sub.f32 f30, f22, f26;
sub.f32 f31, f23, f27;
bfe.u32 r14, r5, 1, 5;
mul.wide.u32 rd6, r14, 8;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f32, f33}, [rd8];
mul.f32 f36, f31, f33;
mul.f32 f37, f30, f33;
mul.f32 f38, f32, f31;
and.b32 r15, r9, 8;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 992;
add.s32 r18, r16, r17;
add.f32 f39, f23, f27;
add.f32 f40, f22, f26;
st.shared.v2.f32 [r18], {f40, f39};
fma.rn.f32 f41, f32, f30, f36;
sub.f32 f42, f38, f37;
st.shared.v2.f32 [r18+16], {f41, f42};
barrier.sync 0;
and.b32 r19, r9, 496;
sub.s32 r20, r18, r19;
ld.shared.v2.f32 {f43, f44}, [r20];
ld.shared.v2.f32 {f47, f48}, [r20+512];
sub.f32 f51, f43, f47;
sub.f32 f52, f44, f48;
bfe.u32 r21, r5, 2, 4;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f53, f54}, [rd11];
mul.f32 f57, f52, f54;
mul.f32 f58, f51, f54;
mul.f32 f59, f53, f52;
and.b32 r22, r9, 24;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 960;
add.s32 r25, r23, r24;
add.f32 f60, f44, f48;
add.f32 f61, f43, f47;
st.shared.v2.f32 [r25], {f61, f60};
fma.rn.f32 f62, f53, f51, f57;
sub.f32 f63, f59, f58;
st.shared.v2.f32 [r25+32], {f62, f63};
barrier.sync 0;
and.b32 r26, r9, 480;
sub.s32 r27, r25, r26;
ld.shared.v2.f32 {f64, f65}, [r27];
ld.shared.v2.f32 {f68, f69}, [r27+512];
sub.f32 f72, f64, f68;
sub.f32 f73, f65, f69;
and.b32 r28, r5, 56;
cvt.u64.u32 rd12, r28;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f74, f75}, [rd14];
mul.f32 f78, f73, f75;
mul.f32 f79, f72, f75;
mul.f32 f80, f74, f73;
and.b32 r29, r9, 56;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 896;
add.s32 r32, r30, r31;
add.f32 f81, f65, f69;
add.f32 f82, f64, f68;
st.shared.v2.f32 [r32], {f82, f81};
fma.rn.f32 f83, f74, f72, f78;
sub.f32 f84, f80, f79;
st.shared.v2.f32 [r32+64], {f83, f84};
barrier.sync 0;
and.b32 r33, r9, 448;
sub.s32 r34, r32, r33;
ld.shared.v2.f32 {f85, f86}, [r34];
ld.shared.v2.f32 {f89, f90}, [r34+512];
sub.f32 f93, f85, f89;
sub.f32 f94, f86, f90;
bfe.u32 r35, r5, 4, 2;
mul.wide.u32 rd15, r35, 8;
mov.u64 rd16, %9;
add.s64 rd17, rd16, rd15;
ld.global.v2.f32 {f95, f96}, [rd17];
mul.f32 f99, f94, f96;
mul.f32 f100, f93, f96;
mul.f32 f101, f95, f94;
and.b32 r36, r9, 120;
add.s32 r37, r8, r36;
barrier.sync 0;
and.b32 r38, r6, 768;
add.s32 r39, r37, r38;
add.f32 f102, f86, f90;
add.f32 f103, f85, f89;
st.shared.v2.f32 [r39], {f103, f102};
fma.rn.f32 f104, f95, f93, f99;
sub.f32 f105, f101, f100;
st.shared.v2.f32 [r39+128], {f104, f105};
barrier.sync 0;
and.b32 r40, r9, 384;
sub.s32 r41, r39, r40;
ld.shared.v2.f32 {f106, f107}, [r41];
ld.shared.v2.f32 {f110, f111}, [r41+512];
sub.f32 f114, f106, f110;
sub.f32 f115, f107, f111;
bfe.u32 r42, r5, 5, 1;
mul.wide.u32 rd18, r42, 8;
mov.u64 rd19, %10;
add.s64 rd20, rd19, rd18;
ld.global.v2.f32 {f116, f117}, [rd20];
mul.f32 f120, f115, f117;
mul.f32 f121, f114, f117;
mul.f32 f122, f116, f115;
and.b32 r43, r9, 248;
add.s32 r44, r8, r43;
barrier.sync 0;
and.b32 r45, r6, 512;
add.s32 r46, r44, r45;
add.f32 f123, f107, f111;
add.f32 f124, f106, f110;
st.shared.v2.f32 [r46], {f124, f123};
fma.rn.f32 f125, f116, f114, f120;
sub.f32 f126, f122, f121;
st.shared.v2.f32 [r46+256], {f125, f126};
barrier.sync 0;
and.b32 r47, r9, 256;
sub.s32 r48, r46, r47;
ld.shared.v2.f32 {f127, f128}, [r48];
ld.shared.v2.f32 {f131, f132}, [r48+512];
add.f32 %1, f128, f132;
add.f32 %0, f127, f131;
sub.f32 %3, f128, f132;
sub.f32 %2, f127, f131;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y): "r"(smem), "l"(lut_sp_2_128), "l"(lut_sp_2_64), "l"(lut_sp_2_32), "l"(lut_sp_2_16), "l"(lut_sp_2_8), "l"(lut_sp_2_4), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<262, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<115>;
.reg .b32 r<49>;
.reg .b64 rd<21>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 9;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f9, %11, %13;
add.f32 f10, %12, %14;
sub.f32 f11, %11, %13;
sub.f32 f12, %12, %14;
shl.b32 r6, r5, 3;
cvt.u64.u32 rd2, r6;
and.b64 rd3, rd2, 504;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f13, f14}, [rd5];
mul.f32 f17, f12, f14;
fma.rn.f32 f18, f13, f11, f17;
mul.f32 f19, f11, f14;
mul.f32 f20, f13, f12;
sub.f32 f21, f20, f19;
and.b32 r7, r6, -512;
add.s32 r8, r4, r7;
barrier.sync 0;
and.b32 r9, r6, 504;
add.s32 r10, r8, r9;
st.shared.v2.f32 [r10], {f9, f18};
barrier.sync 0;
shl.b32 r11, r5, 2;
and.b32 r12, r11, 252;
sub.s32 r13, r10, r12;
ld.shared.f32 f22, [r13];
ld.shared.f32 f23, [r13+256];
barrier.sync 0;
st.shared.v2.f32 [r10], {f10, f21};
barrier.sync 0;
ld.shared.f32 f24, [r13];
ld.shared.f32 f25, [r13+256];
add.f32 f26, f22, f23;
add.f32 f27, f24, f25;
sub.f32 f28, f22, f23;
sub.f32 f29, f24, f25;
bfe.u32 r14, r5, 1, 5;
mul.wide.u32 rd6, r14, 8;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f30, f31}, [rd8];
mul.f32 f34, f29, f31;
fma.rn.f32 f35, f30, f28, f34;
mul.f32 f36, f28, f31;
mul.f32 f37, f30, f29;
sub.f32 f38, f37, f36;
and.b32 r15, r11, 4;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 496;
add.s32 r18, r16, r17;
st.shared.f32 [r18], f26;
st.shared.f32 [r18+8], f35;
barrier.sync 0;
and.b32 r19, r11, 248;
sub.s32 r20, r18, r19;
ld.shared.f32 f39, [r20];
ld.shared.f32 f40, [r20+256];
barrier.sync 0;
st.shared.f32 [r18], f27;
st.shared.f32 [r18+8], f38;
barrier.sync 0;
ld.shared.f32 f41, [r20];
ld.shared.f32 f42, [r20+256];
add.f32 f43, f39, f40;
add.f32 f44, f41, f42;
sub.f32 f45, f39, f40;
sub.f32 f46, f41, f42;
bfe.u32 r21, r5, 2, 4;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f47, f48}, [rd11];
mul.f32 f51, f46, f48;
fma.rn.f32 f52, f47, f45, f51;
mul.f32 f53, f45, f48;
mul.f32 f54, f47, f46;
sub.f32 f55, f54, f53;
and.b32 r22, r11, 12;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 480;
add.s32 r25, r23, r24;
st.shared.f32 [r25], f43;
st.shared.f32 [r25+16], f52;
barrier.sync 0;
and.b32 r26, r11, 240;
sub.s32 r27, r25, r26;
ld.shared.f32 f56, [r27];
ld.shared.f32 f57, [r27+256];
barrier.sync 0;
st.shared.f32 [r25], f44;
st.shared.f32 [r25+16], f55;
barrier.sync 0;
ld.shared.f32 f58, [r27];
ld.shared.f32 f59, [r27+256];
add.f32 f60, f56, f57;
add.f32 f61, f58, f59;
sub.f32 f62, f56, f57;
sub.f32 f63, f58, f59;
and.b32 r28, r5, 56;
cvt.u64.u32 rd12, r28;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f64, f65}, [rd14];
mul.f32 f68, f63, f65;
fma.rn.f32 f69, f64, f62, f68;
mul.f32 f70, f62, f65;
mul.f32 f71, f64, f63;
sub.f32 f72, f71, f70;
and.b32 r29, r11, 28;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 448;
add.s32 r32, r30, r31;
st.shared.f32 [r32], f60;
st.shared.f32 [r32+32], f69;
barrier.sync 0;
and.b32 r33, r11, 224;
sub.s32 r34, r32, r33;
ld.shared.f32 f73, [r34];
ld.shared.f32 f74, [r34+256];
barrier.sync 0;
st.shared.f32 [r32], f61;
st.shared.f32 [r32+32], f72;
barrier.sync 0;
ld.shared.f32 f75, [r34];
ld.shared.f32 f76, [r34+256];
add.f32 f77, f73, f74;
add.f32 f78, f75, f76;
sub.f32 f79, f73, f74;
sub.f32 f80, f75, f76;
bfe.u32 r35, r5, 4, 2;
mul.wide.u32 rd15, r35, 8;
mov.u64 rd16, %9;
add.s64 rd17, rd16, rd15;
ld.global.v2.f32 {f81, f82}, [rd17];
mul.f32 f85, f80, f82;
fma.rn.f32 f86, f81, f79, f85;
mul.f32 f87, f79, f82;
mul.f32 f88, f81, f80;
sub.f32 f89, f88, f87;
and.b32 r36, r11, 60;
add.s32 r37, r8, r36;
barrier.sync 0;
and.b32 r38, r6, 384;
add.s32 r39, r37, r38;
st.shared.f32 [r39], f77;
st.shared.f32 [r39+64], f86;
barrier.sync 0;
and.b32 r40, r11, 192;
sub.s32 r41, r39, r40;
ld.shared.f32 f90, [r41];
ld.shared.f32 f91, [r41+256];
barrier.sync 0;
st.shared.f32 [r39], f78;
st.shared.f32 [r39+64], f89;
barrier.sync 0;
ld.shared.f32 f92, [r41];
ld.shared.f32 f93, [r41+256];
add.f32 f94, f90, f91;
add.f32 f95, f92, f93;
sub.f32 f96, f90, f91;
sub.f32 f97, f92, f93;
bfe.u32 r42, r5, 5, 1;
mul.wide.u32 rd18, r42, 8;
mov.u64 rd19, %10;
add.s64 rd20, rd19, rd18;
ld.global.v2.f32 {f98, f99}, [rd20];
mul.f32 f102, f97, f99;
fma.rn.f32 f103, f98, f96, f102;
mul.f32 f104, f96, f99;
mul.f32 f105, f98, f97;
sub.f32 f106, f105, f104;
and.b32 r43, r11, 124;
add.s32 r44, r8, r43;
barrier.sync 0;
and.b32 r45, r6, 256;
add.s32 r46, r44, r45;
st.shared.f32 [r46], f94;
st.shared.f32 [r46+128], f103;
barrier.sync 0;
and.b32 r47, r11, 128;
sub.s32 r48, r46, r47;
ld.shared.f32 f107, [r48];
ld.shared.f32 f108, [r48+256];
barrier.sync 0;
st.shared.f32 [r46], f95;
st.shared.f32 [r46+128], f106;
barrier.sync 0;
ld.shared.f32 f109, [r48];
ld.shared.f32 f110, [r48+256];
add.f32 %0, f107, f108;
add.f32 %1, f109, f110;
sub.f32 %2, f107, f108;
sub.f32 %3, f109, f110;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y): "r"(smem), "l"(lut_sp_2_128), "l"(lut_sp_2_64), "l"(lut_sp_2_32), "l"(lut_sp_2_16), "l"(lut_sp_2_8), "l"(lut_sp_2_4), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y));
};


#endif
